% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.plot.heatmap.r
\name{gl.plot.heatmap}
\alias{gl.plot.heatmap}
\title{Represent a distance matrix as a heatmap}
\usage{
gl.plot.heatmap(D, verbose = NULL)
}
\arguments{
\item{D}{-- name of the distance matrix or class fd object [required]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\description{
The script plots a heat map to represent the distances in the distance or dissimilarity matrix
}
\examples{
   gl <- testset.gl[1:10,]
   D <- dist(as.matrix(gl),upper=TRUE,diag=TRUE)
   gl.plot.heatmap(D)
   D2 <- gl.dist.pop(testset.gl)
   gl.plot.heatmap(D2)
   D3 <- gl.fixed.diff(testset.gl)
   gl.plot.heatmap(D3)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr}) as a wrapper for pheatmap by Raivo Kolde.
}
