% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.test.heterozygosity.r
\name{gl.test.heterozygosity}
\alias{gl.test.heterozygosity}
\title{Tests the difference in heterozyosity between populations taken pairwise.}
\usage{
gl.test.heterozygosity(
  x,
  nreps = 10000,
  alpha1 = 0.05,
  alpha2 = 0.01,
  plot = FALSE,
  plot.out = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{-- a genlight object containing the SNP genotypes [Required]}

\item{nreps}{-- number of replications of the re-randomization [10,000]}

\item{alpha1}{-- significance level for comparison with diff=0 on plot [0.05]}

\item{alpha2}{-- second significance level for comparison with diff=0 on plot [0.01]}

\item{plot}{-- if TRUE, plots a sampling distribution of the differences for each comparison [FALSE]}

\item{plot.out}{-- if TRUE, outputs the plots as jpeg [FALSE]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
returns a dataframe containing population labels, heterozygosities and sample sizes
}
\description{
Calculates the expected heterozygosities for each population in a genlight object,
and uses re-randomization to test the statistical significance of differences
in heterozyosity between populations taken pairwise.
}
\details{
Optionally plots the sampling distribution for the difference between each pair
of heterozygosities, marked with the critical limits alpha1 and alpha2, the observed
heterozygosity, and the zero value (if in range). Can output the plots to jpeg.
}
\examples{
gl.report.heterozygosity(possums.gl[1:120,])
out <- gl.test.heterozygosity(possums.gl[1:120,], nreps=10, verbose=3, plot=TRUE)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
