% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.overshoot.r
\name{gl.report.overshoot}
\alias{gl.report.overshoot}
\title{Reports loci for which the SNP has been trimmed from the sequence tag along with the adaptor}
\usage{
gl.report.overshoot(x, verbose = NULL)
}
\arguments{
\item{x}{-- name of the genlight object [required]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
returns names of the recalcitrant loci
}
\description{
This function checks the position of the SNP within the trimmed sequence tag and identifies those for which the SNP position is outside
the trimmed sequence tag. This can happen, rarely, when the sequence containing the SNP resembles the adaptor.
}
\details{
The SNP genotype can still be used in most analyses, but functions like gl2fasta() will present challenges if the SNP has been trimmed from
the sequence tag.
}
\examples{
out <- gl.report.overshoot(testset.gl)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
