% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2genalex.r
\name{gl2genalex}
\alias{gl2genalex}
\title{Convert a genlight object to format suitable for input to genalex}
\usage{
gl2genalex(x, outfile = "genalex.csv", outpath = tempdir(), verbose = NULL)
}
\arguments{
\item{x}{-- name of the genlight object containing the SNP data [required]}

\item{outfile}{-- file name of the output file (including extension) [default 'genalex.csv']}

\item{outpath}{-- path where to save the output file [default tempdir()]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\description{
The output csv file contains the snp data and other relevant lines suitable for genalex. This script is a wrapper for genind2genalex {poppr}
}
\details{
Reference: Peakall, R. and Smouse P.E. (2012) GenAlEx 6.5: genetic analysis in Excel. Population genetic software for teaching and research-an update. Bioinformatics 28, 2537-2539.
http://bioinformatics.oxfordjournals.org/content/28/19/2537
}
\examples{
\donttest{
gl2genalex(testset.gl, outfile="testset.csv")
}
}
\author{
Katrin Hohwieler, wrapper Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
