% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2structure.r
\name{gl2structure}
\alias{gl2structure}
\title{Converts genlight objects to STRUCTURE formated files}
\usage{
gl2structure(gl, indNames = NULL, addcolumns = NULL, ploidy = 2,
  exportMarkerNames = TRUE, outfile = "gl.str", outpath = tempdir(),
  v = 1)
}
\arguments{
\item{gl}{-- genlight containing lat longs [required]}

\item{indNames}{-- switch if individuals names should be added (defult to indNames in gl)}

\item{addcolumns}{-- additional columns to be added  before genotypes}

\item{ploidy}{-- defaults to 2}

\item{exportMarkerNames}{-- switch if loci names should be included (locNames(gl))}

\item{outfile}{-- name (path) of the output shape file}

\item{outpath}{-- path of the output file. Default is to tempdir(). If to be saved in the current working directory change to "."}

\item{v}{-- verbosity: if v=0 no output, v=1 reports name and path of output file. default 1}
}
\description{
This function exports genlight objects to STRUCTURE formatted files (be aware there is a gl2faststruture version as well). It is based on the code provided by Lindsay Clark (see \url{https://github.com/lvclark/R_genetics_conv})  and this function is basically a wrapper around her numeric2structure function. See also: Lindsay Clark. (2017, August 22). lvclark/R_genetics_conv: R_genetics_conv 1.1 (Version v1.1). Zenodo: \url{http://doi.org/10.5281/zenodo.846816}.
}
\examples{
\donttest{
gl2structure(testset.gl)
}
}
\author{
Bernd Gruber (wrapper) and Lindsay V. Clark [lvclark@illinois.edu]
}
