% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2fasta.r
\name{gl2fasta}
\alias{gl2fasta}
\title{Concatenates DArT trimmed sequences and outputs a fastA file.}
\usage{
gl2fasta(gl, method = 1, outfile = "output.fasta", outpath = tempdir())
}
\arguments{
\item{gl}{-- name of the DArT genlight object [required]}

\item{method}{-- 1 | 2 | 3 | 4. Type method=0 for a list of options  [method=1]}

\item{outfile}{-- name of the output file (fasta format) [output.fasta]}

\item{outpath}{-- path where to save the output file (set to tempdir by default)}
}
\value{
A new gl object with all loci rendered homozygous
}
\description{
Concatenated sequence tags are useful for phylogenetic methods where information
on base frequencies and transition and transversion ratios are required (for
example, Maximum Liklihood methods). Where relevant, heterozygous loci are resolved 
before concatenation by either assigning ambiguity codes or by random allele 
assignment.
}
\details{
Four methods are employed

Method 1 -- heterozygous positions are replaced by
the standard ambiguity codes. The resultant sequence fragments are concatenated across loci to generate
a single combined sequence to be used in subsequent ML phylogenetic analyses.

Method=2 -- the heterozyous state is resolved by randomly assigning one or the other SNP variant
to the individual. The resultant sequence fragments are concatenated across loci to generate
a single composite haplotype to be used in subsequent ML phylogenetic analyses.

Method 3 -- heterozygous positions are replaced by
the standard ambiguity codes. The resultant SNP bases are concatenated across loci to generate
a single combined sequence to be used in subsequent MP phylogenetic analyses.

Method=4 -- the heterozyous state is resolved by randomly assigning one or the other SNP variant
to the individual. The resultant SNP bases are concatenated across loci to generate
a single composite haplotype to be used in subsequent MP phylogenetic analyses.

Trimmed sequences for which the SNP has been trimmed out, rarely, by adaptor mis-identity are deleted.

The script writes out the composite haplotypes for each individual as a fastA file. Requires
'TrimmedSequence' to be among the locus metrics (\code{@other$loc.metrics}) and information of the type of alleles (slot loc.all e.g. "G/A") and the position of the SNP in slot position of the ```genlight``` object (see testset.gl@position and testset.gl@loc.all for how to format these slots.)
}
\examples{
gl <- gl.filter.repavg(testset.gl,t=1)
gl <- gl.filter.callrate(testset.gl,t=.98)
gl2fasta(gl, method=1, outfile="test.fasta")
}
\author{
Bernd Gruber and Arthur Georges (glbugs@aerg.canberra.edu.au)
}
