% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gi.outflank.r
\name{gi.outflank}
\alias{gi.outflank}
\title{Functio to identify loci under selection per population using the outflank method of Whitlock and Lotterhos (2015)}
\usage{
gi.outflank(gi, plot = TRUE)
}
\arguments{
\item{gi}{a genind object, with a defined population structure}

\item{plot}{a switch if a barplot is wanted.}
}
\value{
returns an index of outliers and the full outflank list
}
\description{
Functio to identify loci under selection per population using the outflank method of Whitlock and Lotterhos (2015)
}
\details{
this function is a wrapper around the outflank function provided by Whitlock and Lotterhus. To be able to run this function the packages qvalue (from bioconductor) and outflank (from github) needs to be installed. To do so see example below.
}
\examples{
\dontrun{
#install qvalue from bioconductor and outflank from github 
source("http://bioconductor.org/biocLite.R")
biocLite("qvalue") 
library(devtools)
install_github("Whitlock/OutFLANK")
# now we are able to run outflank using a genlight object
gi.outflank(gi, plot = TRUE)
}
}
\references{
Whitlock, M.C. and Lotterhos K.J. (2015) Reliable detection of loci responsible for local adaptation: inference of a neutral model through trimming the distribution of Fst. The American Naturalist 186: 24 - 36.
}

