% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.DArch}
\alias{predict.DArch}
\title{Forward-propagate data.}
\usage{
\method{predict}{DArch}(object, ..., newdata = NULL, type = "raw",
  inputLayer = 1, outputLayer = 0)
}
\arguments{
\item{object}{\code{\linkS4class{DArch}} instance}

\item{...}{Further parameters, if \code{newdata} is \code{NULL}, the first
unnamed parameter will be used for \code{newdata} instead.}

\item{newdata}{New data to predict, \code{NULL} to return latest network
output}

\item{type}{Output type, one of: \code{raw}, \code{bin}, \code{class}, or
\code{character}. \code{raw} returns the layer output, \code{bin} returns
\code{1} for every layer output \code{>0.5}, \code{0} otherwise, and
\code{class} returns \code{1} for the output unit with the highest
activation, otherwise \code{0}. Additionally, when using \code{class},
class labels are returned when available. \code{character} is the same as
\code{class}, except using character vectors instead of factors.}

\item{inputLayer}{Layer number (\code{> 0}). The data given in
\code{newdata} will be fed into this layer.
Note that absolute numbers count from the input layer, i.e. for
a network with three layers, \code{1} would indicate the input layer.}

\item{outputLayer}{Layer number (if \code{> 0}) or offset (if \code{<= 0})
relative to the last layer. The output of the given layer is returned.
Note that absolute numbers count from the input layer, i.e. for
a network with three layers, \code{1} would indicate the input layer.}
}
\value{
Vector or matrix of networks outputs, output type depending on the 
  \code{type} parameter.
}
\description{
Forward-propagate given data through the deep neural network.
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris, retainData = T)
predict(model)
}
}
\seealso{
Other darch interface functions: \code{\link{darchBench}},
  \code{\link{darchTest}}, \code{\link{darch}},
  \code{\link{plot.DArch}}, \code{\link{print.DArch}}
}

