% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_activity_order_violations.R
\name{detect_activity_order_violations}
\alias{detect_activity_order_violations}
\alias{detect_activity_order_violations.activitylog}
\title{Detect activity order violations}
\usage{
detect_activity_order_violations(
  activitylog,
  activity_order,
  timestamp,
  details,
  filter_condition
)

\method{detect_activity_order_violations}{activitylog}(
  activitylog,
  activity_order,
  timestamp = c("both", "start", "complete"),
  details = TRUE,
  filter_condition = NULL
)
}
\arguments{
\item{activitylog}{The activity log}

\item{activity_order}{Vector expressing the activity order that needs to be checked (using activity names)}

\item{timestamp}{Type of timestamp that needs to be taken into account in the analysis (either "start", "complete" or "both)}

\item{details}{Boolean indicating wheter details of the results need to be shown}

\item{filter_condition}{Condition that is used to extract a subset of the activity log prior to the application of the function}
}
\value{
tbl_df providing an overview of detected activity orders which violate the specified activity order
}
\description{
Function detecting violations in activity order. Having additional or less activity types than those specified in activity_order is no violation, but the activity types present should occur in the specified order, and only once.
}
\section{Methods (by class)}{
\itemize{
\item \code{activitylog}: Detect activity order_violations in activity log.
}}

\examples{
\donttest{
data("hospital_actlog")
detect_activity_order_violations(activitylog = hospital_actlog,
     activity_order = c(
         "Registration",
         "Triage",
         "Clinical exam",
         "Treatment",
         "Treatment evaluation"))
}
}
