% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_eigenvalues.R
\name{graph_eigenvalues_df}
\alias{graph_eigenvalues_df}
\title{A helper for sub_dann_df}
\usage{
graph_eigenvalues_df(
  formula,
  train,
  neighborhood_size = max(floor(nrow(train)/5), 50),
  weighted = FALSE,
  sphere = "mcd"
)
}
\arguments{
\item{formula}{An object of class formula. (Y ~ X1 + X2)}

\item{train}{A data frame or tibble containing training data.}

\item{neighborhood_size}{The number of data points used to calculate between and within class covariance.}

\item{weighted}{weighted argument to ncoord. See \code{\link[fpc]{ncoord}} for details.}

\item{sphere}{One of "mcd", "mve", "classical", or "none" See \code{\link[fpc]{ncoord}} for details.}
}
\value{
A ggplot2 graph.
}
\description{
A helper for sub_dann_df
}
\details{
This function plots the eigenvalues found by \code{\link[fpc]{ncoord}}. The user
should make a judgement call on how many eigenvalues are large and set sub_dann_df's
numDim to that number.
}
\examples{
library(dann)
library(mlbench)
library(magrittr)
library(dplyr)

######################
# Circle data with 2 related variables and 5 unrelated variables
######################
set.seed(1)
train <- mlbench.circle(300, 2) \%>\%
  tibble::as_tibble()
colnames(train)[1:3] <- c("X1", "X2", "Y")
train <- train \%>\%
  mutate(Y = as.numeric(Y))

# Add 5 unrelated variables
train <- train \%>\%
  mutate(
    U1 = runif(300, -1, 1),
    U2 = runif(300, -1, 1),
    U3 = runif(300, -1, 1),
    U4 = runif(300, -1, 1),
    U5 = runif(300, -1, 1)
  )

# Graph suggests a subspace with 2 dimensions. The correct answer.
graph_eigenvalues_df(
  formula = Y ~ X1 + X2 + U1 + U2 + U3 + U4 + U5, train = train,
  neighborhood_size = 50, weighted = FALSE, sphere = "mcd"
)

rm(train)
}
