% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dabr.R
\name{insert}
\alias{insert}
\alias{insert.MariaDBConnection}
\title{Execute \code{INSERT} query}
\usage{
insert(conn, ...)

\method{insert}{MariaDBConnection}(conn, ..., quiet = FALSE)
}
\arguments{
\item{conn}{DB connection object.}

\item{...}{\code{INSERT} query and optional parameters.}

\item{quiet}{Boolean flag to hide status messages.}
}
\description{
Execute \code{INSERT} query
}
\examples{
\dontrun{
conn <- open_conn_mysql("sys", "root")
query <- paste0(
  "INSERT INTO sys_config (variable, value, set_time, set_by) VALUES ",
  "('test_var', 999, '", Sys.time(), "', NULL)"
)
out <- insert(conn, query)
close_conn(conn)
}
}
\seealso{
Other DB functions: 
\code{\link{close_conn}()},
\code{\link{delete}()},
\code{\link{list_tables}()},
\code{\link{open_conn_mysql}()},
\code{\link{select_all}()},
\code{\link{select}()},
\code{\link{update}()}
}
\concept{DB functions}
