% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_tools.R
\name{simulate_values}
\alias{simulate_values}
\title{Simulate Values}
\usage{
simulate_values(
  lower,
  upper,
  k,
  distr = NULL,
  cast_to_data_frame = TRUE,
  add_id_column = "numeric",
  seed = NULL,
  ...
)
}
\arguments{
\item{lower, upper}{Numeric vectors, indicating the lower/upper boundary of
the drawn values.}

\item{k}{Numeric, the number of values to be drawn for each value pair of
lower/upper. If named numeric, the labels are used for the column names
of the returned object}

\item{distr}{Character, indicating which distribution to draw from. Currently
available are: \code{"unif"} for a uniform distribution or \code{"tnorm"} for a
truncated normal distribution. \code{NUll} will lead to \code{"unif"} (default).}

\item{cast_to_data_frame}{Logical, controls whether the returned object
is of type data.frame (TRUE) or matrix (FALSE). Default is TRUE}

\item{add_id_column}{Character, controls whether an ID column should be
added. Options are "numeric", "character", or "none". If "numeric" or
"character" the column ID provides values from 1 to k of the respective type.
If none, no column is added. Note that "character" casts all simulated values
to character if the argument \code{cast_to_data_frame} is set to FALSE.}

\item{seed}{Numeric, optional seed for making the simulation reproducable
(see details)}

\item{...}{Further arguments relevant for the distribution to draw from}
}
\value{
If \code{cast_to_data_frame} is TRUE, a data.frame with \code{k} rows and at least
\code{length(lower);length(upper)} columns. Otherwise a matrix with
the same number of rows and columns. Columns are labeled either from V1 to
Vk or in case \code{lower} and \code{upper} are named numeric vectors using the
labels of both vectors.

If \code{add_id_column} is not "none", an ID column is provided of the respective
data type.

The data type of the parameters will be numeric, unless \code{add_id_column}
is "character" and \code{cast_to_data_frame} is FALSE. In this case the returned
matrix will be of type character.
}
\description{
Draw values, most likely model parameters.
}
\details{
When drawing from a truncated normal distribution, users must provide values
for the arguments \code{means} and \code{sds}. These are numeric vectors of the same
size as \code{lower} and \code{upper}, and indicate the mean and the standard deviation
of the normal distributions.
}
\examples{

# Example 1: Draw from uniform distributions ------------------------------
lower <- c(a = 1, b = 1, c = 1)
upper <- c(a = 3, b = 4, c = 5)
values <- simulate_values(
  lower = lower,
  upper = upper,
  k = 50,
  add_id_column = "none"
)
summary(values)

# Example 2: Draw from truncated normal distributions ---------------------
lower <- c(a = 1, b = 1, c = 1)
upper <- c(a = 3, b = 4, c = 5)
means <- c(a = 2, b = 2.5, c = 3)
sds <- c(a = 0.5, b = 0.5, c = 0.5)
values <- simulate_values(
  lower = lower,
  upper = upper,
  distr = "tnorm",
  k = 5000,
  add_id_column = "none",
  means = means,
  sds = sds
)
quantile(values$a, probs = c(0.025, 0.5, 0.975))
quantile(values$b, probs = c(0.025, 0.5, 0.975))
quantile(values$c, probs = c(0.025, 0.5, 0.975))

}
