% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R, R/core_flex_prms.R,
%   R/formatting_flex_prms.R
\name{flex_prms<-}
\alias{flex_prms<-}
\alias{flex_prms<-.drift_dm}
\alias{flex_prms}
\alias{flex_prms.numeric}
\alias{flex_prms.flex_prms}
\alias{flex_prms.drift_dm}
\alias{print.flex_prms}
\title{Flex_Prms}
\usage{
flex_prms(object, ...) <- value

\method{flex_prms}{drift_dm}(object, ..., eval_model = FALSE) <- value

flex_prms(object, ...)

\method{flex_prms}{numeric}(object, ..., conds, instr = NULL, messaging = NULL)

\method{flex_prms}{flex_prms}(object, ...)

\method{flex_prms}{drift_dm}(object, ...)

\method{print}{flex_prms}(
  x,
  ...,
  round_digits = drift_dm_default_rounding(),
  dependencies = TRUE,
  cust_parameters = TRUE
)
}
\arguments{
\item{object}{an \code{R} object (see Details)}

\item{...}{additional arguments passed on to the specific method.}

\item{value}{an object of type \code{flex_prms}.}

\item{eval_model}{logical, indicating if the model should be re-evaluated or
not when replacing the \code{flex_prms} object (see \link{re_evaluate_model}).}

\item{conds}{A character vector, giving the names of the model's conditions.
values within \code{conds} will be used when addressing the data and when
deriving the model's predictions.}

\item{instr}{optional string with "instructions", see
\code{\link[=modify_flex_prms]{modify_flex_prms()}}.}

\item{messaging}{optional logical, indicates if messages shall be ushered
when processing \code{instr}.}

\item{x}{an object of type \code{flex_prms}}

\item{round_digits}{integer, controls the number of digits shown when
printing out a \code{flex_prms} object. Default is \code{3}.}

\item{dependencies}{logical, controlling if a summary of the special
dependencies shall be printed.}

\item{cust_parameters}{logical, controlling if a summary of the custom
parameters shall be printed.}
}
\value{
The specific value returned depends on which method is called
\subsection{Creating an object of type \code{flex_prms}}{

Can be achieved by calling \code{flex_prms()} with a named numeric vector, thus
when calling the underlying method \code{flex_prms.numeric} (see the example
below). In this case a list with the class label \code{"flex_prms"} is returned.
It containts three entries:
\itemize{
\item A nested list \code{internal_list}. This list specifies the dependencies
and restrains enforced upon the parameters across conditions. Integers >= 1
indicate that this parameter will be estimated for a specific condition, and
conditions with the same number refer to a single parameter. Integers == 0
indicate thtat this parameter will not be esitmated for a specific condition
(i.e., it is considered "fixed"). Expressions will be evaluated at run time
and specify special dependencies among parameters.
\item A nested list \code{linear_internal_list}. This list essentially contains
the same information as \code{internal_list}, but the parameters are sorted so
that they can be mapped to an integer vector (relevant only in the depths of
the package for the minimization routines).
\item A numeric matrix \code{prms_matrix} which contains the currently set values for
each parameter across all conditions. Per default, the values of each
parameter are set equal across all conditions. Additionally, each parameter
is assumed to be restrained as equal across all conditions.
The values for all parameters given a condition will be passed to the
component functions (see \link{comp_funs}).
\item (optional) A list of additional parameters \code{cust_prms} that are derived
from the parameters in \code{prms_matrix}.
}
}

\subsection{Accessing an object of type \code{flex_prms}}{

Users can access/get the \code{flex_prms} object when calling \code{flex_prms()} with
an object of type \link{drift_dm}, \code{fits_ids_dm}
(see \code{\link[=estimate_model_ids]{estimate_model_ids()}}), or \code{flex_prms}. In this case, the
stored \code{flex_prms} object is returned.
}

\subsection{Replacing an object of type \code{flex_prms}}{

The \code{flex_prms} object stored within an object of type \link{drift_dm}
can be replaced by calling the generic \verb{flex_prms<-} replacement function. In
this case, the modified \link{drift_dm} object is returned.
}

\subsection{Printing an object of type \code{flex_prms}}{

The \code{print.flex_prms()} method invisibly returns the supplied \code{flex_prms}
object.
}
}
\description{
Functions for creating, accessing replacing, or printing a \code{flex_prms} object.
Any object of type \code{flex_prms} provides a user-friendly way to specify
dependencies, parameter values etc. for a model.
}
\details{
Objects of type \code{flex_prms} can be modified using the generic
\code{\link[=modify_flex_prms]{modify_flex_prms()}} function and a corresponding set of
"instructions" (see the respective function for more details).

\code{flex_prms()} is a generic function. If called with a named numeric
vector, then this will create an object of type \code{flex_prms} (requires
\code{conds} to be specified). If called with other data types, gives the
respective \code{flex_prms} object

\verb{flex_prms<-()} is a generic replacement function. Currently this only
supports objects of type \link{drift_dm}. It will replace/update the
model with a new instance of type \code{flex_prms}.
}
\note{
There is only a replacement function for \link{drift_dm} objects. This is
because replacing the solver settings after the model has been fitted (i.e.,
for a \code{fits_ids_dm} object) doesn't make sense.
}
\examples{
# Create a flex_prms object -----------------------------------------------
conds <- c("one", "two")
prms <- c(muc = 3, b = 0.5)
one_instr <- "muc ~ one + two"
flex_prms_obj <- flex_prms(
  prms,
  conds = conds,
  instr = one_instr
)
print(flex_prms_obj)


# Access a flex_prms object of a model ------------------------------------
my_model <- ratcliff_dm() # the Ratcliff DDM comes with dRiftDM
print(flex_prms(my_model))


# Replace the flex_prms object of a model ---------------------------------
# create a new flex_prms object
conds <- c("one", "two")
prms <- c(muc = 3, b = 0.6, non_dec = 0.3)
new_flex_prms_obj <- flex_prms(
  prms,
  conds = conds
)

flex_prms(my_model) <- new_flex_prms_obj

# acess the new flex_prms object
print(flex_prms(my_model))


# Control the print method -------------------------------------------------
dmc_model <- dmc_dm() # another, more complex, model; comes with dRiftDM
print(flex_prms(dmc_model), round_digits = 1, cust_parameters = FALSE)

}
\seealso{
\code{\link[=estimate_model_ids]{estimate_model_ids()}}, \code{\link[=drift_dm]{drift_dm()}},
\code{\link[=summary.flex_prms]{summary.flex_prms()}}, \code{\link[=modify_flex_prms]{modify_flex_prms()}}
}
