% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_cmfactorfit.R
\name{summary.cmfactorfit}
\alias{summary.cmfactorfit}
\title{Summary method for cyclomort factorial fit}
\usage{
\method{summary}{cmfactorfit}(object, ..., coefs = FALSE)
}
\arguments{
\item{object}{a \code{cmfactorfit} object - the output of \code{\link{factorfit_cyclomort}}.}

\item{...}{(not implemented)}

\item{coefs}{whether or not to report the individual summaries of each model component along with the statistical test results}
}
\value{
a table comparing log-likelihood and AIC between null and multi-factor model, and a p-value from likelihood ratio test, optionally combined with the individual model summaries.
}
\description{
Summary method for cyclomort factorial fit
}
\examples{
# fit factorial model
data(seasonalsex)
seasonalsex.factorfit <- factorfit_cyclomort(event ~ sex, data = seasonalsex, n.seasons = 1)

# summary
summary(seasonalsex.factorfit, coefs = TRUE)
\donttest{plot(seasonalsex.factorfit)}
}
