\name{getDynLib-methods}
\docType{methods}
\alias{getDynLib}
\alias{getDynLib-methods}
\alias{getDynLib,cxxdso-method}
\title{Retrieve the dynamic library (or DLL) associated with 
       an object of class \code{cxxdso}} 
\description{
  The \code{getDynLib} function retrieves the dynamic library (or DLL)
  associated with objects of class \code{cxxdso} generated by
  \code{\link{cxxfunctionplus}}
}
\section{Methods}{
\describe{
  \item{\code{signature(x = "cxxdso")}}{Retrieves the dynamic
        library associated with the \code{cxxdso} objects generated by
        \code{\link{cxxfunctionplus}}.}  
}}

\seealso{
  \code{\link{getLoadedDLLs}}, \code{\link{dyn.load}}, 
  \code{\linkS4class{cxxdso}}, and 
  \code{\link[inline:getDynLib]{getDynLib}} in \pkg{inline}
}
\examples{
\dontrun{
dso <- cxxfunctionplus(signature(), "return R_NilValue;")
dll <- getDynLib(dso)
}} 

