% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_limit_sim.R
\name{racusum_limit_sim}
\alias{racusum_limit_sim}
\title{Simulate control limit given false signal probability alpha for RA-CUSUM charts}
\usage{
racusum_limit_sim(patient_risks, odds_multiplier, n_simulation, alpha,
  seed = NULL)
}
\arguments{
\item{patient_risks}{Double. Vector of patient risk scores (individual risk of adverse event)}

\item{odds_multiplier}{Double. Odds multiplier of adverse event under the alternative hypothesis (<1 looks for decreases)}

\item{n_simulation}{Integer. Number of simulation runs}

\item{alpha}{Double. False signal probability of RA-CUSUM}

\item{seed}{Integer. Seed for RNG}
}
\value{
Returns the control limit for signalling performance change (double)
}
\description{
False-signal-probability-simulation of Control Limits h for risk-adjusted CUSUM charts
}
\examples{

# Patients risks are usually known from Phase I.
# If not, these risk scores can be simulated.

# define possible patient risk scores
risks <- c(0.001, 0.01, 0.1, 0.002, 0.02, 0.2)

# sample risk population of size n = 100
set.seed(2046)
patient_risks <- sample(x = risks, size = 100, replace = TRUE)

# simulate control limits for alpha = 0.05
racusum_limit_sim(patient_risks,
  odds_multiplier = 2,
  n_simulation = 1000,
  alpha = 0.05,
  seed = 2046
)
}
