% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_map_dfc.R
\name{cp_map_dfc}
\alias{cp_map_dfc}
\title{Wrapper function of \code{purrr::map}. Apply a function to each element of a vector, but save the intermediate data after a given number of iterations.}
\usage{
cp_map_dfc(.x, .f, ..., name = NULL, cp_options = list())
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A function, specified in one of the following ways:
\itemize{
\item A named function, e.g. \code{mean}.
\item An anonymous function, e.g. \verb{\\(x) x + 1} or \code{function(x) x + 1}.
\item A formula, e.g. \code{~ .x + 1}. You must use \code{.x} to refer to the first
argument. Only recommended if you require backward compatibility with
older versions of R.
}}

\item{...}{Additional arguments passed on to the mapped function.}

\item{name}{Name for the subfolder in the cache folder. If you do not specify,
then \code{cp_map} uses the name of the function combined with the name of x.
This is dangerous, since this generated name can appear multiple times in your code.
Also changing x will result a rerun of the code, however you max want to avoid this.
(if a subset of .x matches with the cached one and the function is the same,
then elements of this subset won't evaluated, rather read from the cache)}

\item{cp_options}{Options for the evaluation: \code{wait}, \code{n_checkpoint}, \code{workers}, \code{fill}.
\itemize{
\item \code{wait}: An integer to specify that after how many iterations the console shows the intermediate results (default \code{1}).
If its value is between 0 and 1, then it is taken as proportions of iterations to wait (example length of .x equals 100, then
you get back the result after 50 if you set it to 0.5). Set to \code{Inf} to get back the results only after full evaluations.
If its value is not equal to \code{Inf} then evaluation is goind in background job.
\item \code{n_chekpoint}: Number of checkpoints, when intermadiate results are saved (default = 100).
\item \code{workers}: Number of CPU cores to use (parallel package called in background). Set to 1 (default) to avoid parallel computing.
\item \code{fill()} When you get back a not fully evaluated result (default \code{TRUE}). Should the length of the result be the same as .x?
}

You can set these options also with \code{options(currr.n_checkpoint = 200)}. Additional options: \code{currr.unchanged_message} (TRUE/FALSE), \code{currr.progress_length}}
}
\value{
A tibble.
}
\description{
The map functions transform their input by applying a function to
each element of a list or atomic vector and returning an object of
the same length as the input. \code{cp_map} functions work exactly the
same way, but creates a secret folder in your current working directory
and saves the results if they reach a given checkpoint. This way
if you rerun the code, it reads the result from the cache folder
and start to evalutate where you finished.
\itemize{
\item \code{cp_map()} always returns a list.
\item \code{map_lgl()}, \code{map_dbl()} and \code{map_chr()} return an
atomic vector of the indicated type (or die trying). For these functions,
\code{.f} must return a length-1 vector of the appropriate type.
}
}
\examples{
# Run them on console!
# (functions need writing and reading access to your working directory and they also print)

avg_n <- function(.data, .col, x) {
  Sys.sleep(.01)

  .data |>
    dplyr::pull({{ .col }}) |>
    (\(m) mean(m) * x) ()
}


cp_map(.x = 1:10, .f = avg_n, .data = iris, .col = Sepal.Length, name = "iris_mean")

 # same function, read from cache
cp_map(.x = 1:10, .f = avg_n, .data = iris, .col = Sepal.Length, name = "iris_mean")

remove_currr_cache()

}
\seealso{
Other map variants: 
\code{\link{cp_map_chr}()},
\code{\link{cp_map_dbl}()},
\code{\link{cp_map_dfr}()},
\code{\link{cp_map_lgl}()},
\code{\link{cp_map}()}
}
\concept{map variants}
