% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter.R
\name{define_parameter_type}
\alias{define_parameter_type}
\title{Define Parameter Type}
\usage{
define_parameter_type(name, regexp, transformer)
}
\arguments{
\item{name}{The name of the parameter.}

\item{regexp}{A regular expression that the parameter will match on. Note that if you want to escape a special character,
you need to use four backslashes.}

\item{transformer}{A function that will transform the parameter from a string to the desired type.
Must be a funcion that requires only a single argument.}
}
\value{
An object of class \code{parameter}, invisibly. Function should be called for side effects.
}
\description{
Add a new parameter that can be used in step definitions.
}
\examples{
define_parameter_type("color", "red|blue|green", as.character)
define_parameter_type(
  name = "sci_number",
  regexp = "[+-]?\\\\\\\\d*\\\\\\\\.?\\\\\\\\d+(e[+-]?\\\\\\\\d+)?",
  transform = as.double
)
}
