% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_index.R
\name{get_cscg}
\alias{get_cscg}
\title{Mean Codon Stabilization Coefficients}
\usage{
get_cscg(cf, csc)
}
\arguments{
\item{cf}{matrix of codon frequencies as calculated by \code{count_codons()}.}

\item{csc}{table of Codon Stabilization Coefficients as calculated by \code{est_csc()}.}
}
\value{
a named vector of cscg values.
}
\description{
\code{get_cscg} calculates Mean Codon Stabilization Coefficients of each CDS.
}
\examples{
# estimate CSCg of yeast genes
yeast_csc <- est_csc(yeast_cds, yeast_half_life)
cf_all <- count_codons(yeast_cds)
cscg <- get_cscg(cf_all, csc = yeast_csc)
head(cscg)
hist(cscg)

}
\references{
Presnyak V, Alhusaini N, Chen YH, Martin S, Morris N, Kline N, Olson S, Weinberg D,
  Baker KE, Graveley BR, et al. 2015. Codon optimality is a major determinant of mRNA stability.
  Cell 160:1111-1124.
}
