% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_index.R
\name{get_enc}
\alias{get_enc}
\title{Calculate ENC}
\usage{
get_enc(cf, codon_table = get_codon_table())
}
\arguments{
\item{cf}{matrix of codon frequencies as calculated by `count_codons()`.}

\item{codon_table}{codon_table a table of genetic code derived from `get_codon_table` or `create_codon_table`.}
}
\value{
vector of ENC values, sequence names are used as vector names
}
\description{
\code{get_enc} computes ENC of each CDS
}
\examples{
# estimate ENC of yeast genes
cf_all <- count_codons(yeast_cds)
enc <- get_enc(cf_all)
head(enc)
hist(enc)
}
\references{
- Wright F. 1990. The 'effective number of codons' used in a gene. Gene 87:23-29.
- Sun X, Yang Q, Xia X. 2013. An improved implementation of effective number of codons (NC).
  Mol Biol Evol 30:191-196.
}
