% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_likelyPlatformTrial.R
\name{f.likelyPlatformTrial}
\alias{f.likelyPlatformTrial}
\title{Calculate if study is likely a platform trial or not}
\usage{
f.likelyPlatformTrial(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and `.likelyPlatformTrial`, a logical,
`.likelyRelatedTrials`, a list (e.g., from CTIS' `associatedClinicalTrials`)
and `.maybeRelatedTrials`, a list (based on similar short terms within
a first set of brackets or before a colon in the title).
}
\description{
Trial concept calculated: platform trial, research platform.
As operational definition, at least one of these criteria is true:
a. trial has "platform", "basket", "umbrella", "multi.?arm", "multi.?stage"
or "master protocol" in its title or description (for ISRCTN, this is the
only criterion; some trials in EUCTR lack data in English),
b. trial has more than 2 active arms with different investigational medicines,
after excluding comparator, auxiliary and placebo medicines (calculated with
\link{f.numTestArmsSubstances}; not used for ISRCTN because it cannot be
calculated precisely),
c. trial more than 2 periods, after excluding safety run-in, screening,
enrolling, extension and follow-up periods (for CTGOV and CTGOV2, this
criterion requires results-related data).
Requires that EUCTR results have been included in the collection, using
ctrLoadQueryIntoDb(queryterm = ..., euctrresults = TRUE, con = ...).
Requires packages dplyr and stringdist to be installed; stringdist is used
for evaluating terms in brackets in the trial title, where trials may be
related if the term similarity is 0.7 or higher.
}
\details{
Publication references considered:
E-PEARL WP2 2020 https://tinyurl.com/eupearld21terminology (which did not
include all basket trials in the definition, as done here)
Williams RJ et al. 2022 https://doi.org/10.1136/bmj-2021-067745
}
\examples{
# fields needed
f.likelyPlatformTrial()

\dontrun{

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.likelyPlatformTrial",
  con = dbc)
}


}
