% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_startDate.R
\name{f.startDate}
\alias{f.startDate}
\title{Calculate start date of a study}
\usage{
f.startDate(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and `.startDate`, a date.
}
\description{
Trial concept calculated: start of the trial, based on the
documented or planned start of recruitment, or on the date of opinion
of the competent authority.
}
\examples{
# fields needed
f.startDate()

\dontrun{

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.startDate",
  con = dbc)
}

}
