% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_timeseries.R
\name{crypto_timeseries}
\alias{crypto_timeseries}
\title{Daily crypto currency market data}
\usage{
crypto_timeseries(coin = NULL)
}
\arguments{
\item{coin}{Name, symbol or slug of crypto currency}
}
\value{
Daily time series of token data in a dataframe:
  \item{timestamp}{Timestamp (POSIXct)}
  \item{market_cap}{Market Cap in USD}
  \item{price_btc}{Price in BTC}
  \item{price_usd}{Price in USD}
  \item{volume}{Volume traded in USD}
  \item{slug}{Coin URL slug (unique)}
}
\description{
Retrieve time series of market_cap, price_btc, price_usd and volume
of specified coin - perfect for charting or time series analysis.
}
\details{
Most tokens are refreshed every 6 hours.. results may vary.
}
\examples{
\dontrun{
coin       <- 'kin'
kin_charts <- crypto_timeseries(coin)
}
}
