% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design-methods.R
\docType{methods}
\name{simulate,TDsamplesDesign-method}
\alias{simulate,TDsamplesDesign-method}
\title{This is a methods to simulate dose escalation procedure only using the DLE responses.
This is a method based on the \code{\linkS4class{TDsamplesDesign}} where model used are of
\code{\linkS4class{ModelTox}} class object DLE samples are also used}
\usage{
\S4method{simulate}{TDsamplesDesign}(object, nsim = 1L, seed = NULL, truth,
  args = NULL, firstSeparate = FALSE, mcmcOptions = McmcOptions(),
  parallel = FALSE, ...)
}
\arguments{
\item{object}{the \code{\linkS4class{TDsamplesDesign}} object we want to simulate the data from}

\item{nsim}{the number of simulations (default :1)}

\item{seed}{see \code{\link{setSeed}}}

\item{truth}{a function which takes as input a dose (vector) and returns the true probability 
(vector) of the occurrence of a DLE. Additional arguments can be supplied in \code{args}.}

\item{args}{data frame with arguments for the \code{truth} function. The
column names correspond to the argument names, the rows to the values of the
arguments. The rows are appropriately recycled in the \code{nsim}
simulations. In order to produce outcomes from the posterior predictive
distribution, e.g, pass an \code{object} that contains the data observed so
far, \code{truth} contains the \code{prob} function from the model in
\code{object}, and \code{args} contains posterior samples from the model.}

\item{firstSeparate}{enroll the first patient separately from the rest of
the cohort? (not default) If yes, the cohort will be closed if a DLT occurs
in this patient.}

\item{mcmcOptions}{object of class \code{\linkS4class{McmcOptions}},
giving the MCMC options for each evaluation in the trial. By default,
the standard options are used}

\item{parallel}{should the simulation runs be parallelized across the
clusters of the computer? (not default)}

\item{\dots}{not used}
}
\value{
an object of class \code{\linkS4class{PseudoSimulations}}

 @export
 @keywords methods
}
\description{
This is a methods to simulate dose escalation procedure only using the DLE responses.
This is a method based on the \code{\linkS4class{TDsamplesDesign}} where model used are of
\code{\linkS4class{ModelTox}} class object DLE samples are also used
}
\examples{
##Simulate dose-escalation procedure based only on DLE responses with DLE samples involved

##The design comprises a model, the escalation rule, starting data, 
##a cohort size and a starting dose
##Define your data set first using an empty data set 
## with dose levels from 25 to 300 with increments 25
data <- Data(doseGrid=seq(25,300,25))

##The design only incorporate DLE responses and DLE samples are involved
##Specified the model of 'ModelTox' class eg 'LogisticIndepBeta' class model
model<-LogisticIndepBeta(binDLE=c(1.05,1.8),DLEweights=c(3,3),DLEdose=c(25,300),data=data)
##Then the escalation rule
tdNextBest<-NextBestTDsamples(targetDuringTrial=0.35,
                              targetEndOfTrial=0.3,
                              derive=function(TDsamples){quantile(TDsamples,probs=0.3)})


## The cohort size, size of 3 subjects
mySize <-CohortSizeConst(size=3)
##Deifne the increments for the dose-escalation process
##The maximum increase of 200\% for doses up to the maximum of the dose specified in the doseGrid
##The maximum increase of 200\% for dose above the maximum of the dose specified in the doseGrid
##This is to specified a maximum of 3-fold restriction in dose-esclation
myIncrements<-IncrementsRelative(intervals=c(min(data@doseGrid),max(data@doseGrid)), 
                                 increments=c(2,2))
##Specified the stopping rule e.g stop when the maximum sample size of 36 patients has been reached
myStopping <- StoppingMinPatients(nPatients=36)

##Specified the design(for details please refer to the 'TDsamplesDesign' example)
design <- TDsamplesDesign(model=model,
                          nextBest=tdNextBest,
                          stopping=myStopping,
                          increments=myIncrements,
                          cohortSize=mySize,
                          data=data,startingDose=25)

##Specify the truth of the DLE responses
myTruth <- function(dose)
{ model@prob(dose, phi1=-53.66584, phi2=10.50499)
}
##then plot the truth to see how the truth dose-DLE curve look like
curve(myTruth(x), from=0, to=300,ylim=c(0,1))

## Then specified the simulations and generate the trial
##options for MCMC
options<-McmcOptions(burnin=100,step=2,samples=200)
##The simulations
##For illustration purpose only 1 simulation is produced (nsim=1). 
mySim <-  simulate(object=design,
                   args=NULL,
                   truth=myTruth,
                   nsim=1,
                   seed=819,
                   mcmcOptions=options,
                   parallel=FALSE)
}
