% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{CohortSizeMax-class}
\alias{.CohortSizeMax}
\alias{CohortSizeMax-class}
\title{Size based on maximum of multiple cohort size rules}
\description{
This class can be used to combine multiple cohort size rules with the MAX
operation.
}
\details{
\code{cohortSizeList} contains all cohort size rules, which are again
objects of class \code{\linkS4class{CohortSize}}. The maximum of these
individual cohort sizes is taken to give the final cohort size.
}
\section{Slots}{

\describe{
\item{\code{cohortSizeList}}{list of cohort size rules}
}}
\examples{

# Rule for having cohort of size 1 for doses <30
#      and having cohort of size 3 for doses >=30
mySize1 <- CohortSizeRange(intervals = c(0, 10),
                           cohortSize = c(1, 3))

# Rule for having cohort of size 1 until no DLT were observed
#      and having cohort of size 3 as soon as 1 DLT is observed
mySize2 <- CohortSizeDLT(DLTintervals=c(0, 1),
                         cohortSize=c(1, 3))

# Create a list of cohort size rules of class 'CohortSizeMax' which will then be 
# combined with the 'max' operation
mySize <- CohortSizeMax(cohortSizeList=list(mySize1, 
                                            mySize2))


}
\keyword{classes}

