% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leave_one_out.R
\name{loo}
\alias{loo}
\title{Performs the leave-one-out analysis}
\usage{
loo(x, verbose = TRUE)
}
\arguments{
\item{x}{a \code{\link{crestObj}} produced by the
\code{\link{crest.reconstruct}} or \code{\link{crest}} functions.}

\item{verbose}{A boolean to print non-essential comments on the terminal
(default \code{TRUE}).}
}
\value{
A \code{\link{crestObj}} object containing the reconstructions and
all the associated data.
}
\description{
Repeat the reconstructions by removing one taxon at a time.
}
\examples{
\dontrun{
  data(crest_ex)
  data(crest_ex_pse)
  data(crest_ex_selection)
  reconstr <- crest(
    df = crest_ex, pse = crest_ex_pse, taxaType = 0,
    climate = c("bio1", "bio12"), bin_width = c(2, 20),
    shape = c("normal", "lognormal"),
    selectedTaxa = crest_ex_selection, dbname = "crest_example"
  )
  reconstr <- loo(reconstr)
}
## example using pre-saved reconstruction obtained with the previous command.
data(reconstr)
lapply(reconstr$reconstructions$bio12$loo, head)
plot_loo(reconstr)

}
