% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.r
\name{combine_styles}
\alias{combine_styles}
\alias{$.crayon}
\title{Combine two or more ANSI styles}
\usage{
combine_styles(...)

\method{$}{crayon}(crayon, style)
}
\arguments{
\item{...}{The styles to combine. They will be applied from
right to left.}

\item{crayon}{A style function.}

\item{style}{A style name that is included in \code{names(styles())}.}
}
\value{
The combined style function.
}
\description{
Combine two or more styles or style functions into a new style function
that can be called on strings to style them.
}
\details{
It does not usually make sense to combine two foreground
colors (or two background colors), because only the first one
applied will be used.

It does make sense to combine different kind of styles,
e.g. background color, foreground color, bold font.

The \code{$} operator can also be used to combine styles.
Note that the left hand side of \code{$} is a style function,
and the right hand side is the name of a style in \code{\link[=styles]{styles()}}.
}
\examples{
## Use style names
alert <- combine_styles("bold", "red4", "bgCyan")
cat(alert("Warning!"), "\n")

## Or style functions
alert <- combine_styles(bold, red, bgCyan)
cat(alert("Warning!"), "\n")

## Combine a composite style
alert <- combine_styles(bold, combine_styles(red, bgCyan))
cat(alert("Warning!"), "\n")

## Shorter notation
alert <- bold $ red $ bgCyan
cat(alert("Warning!"), "\n")
}
