% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{package}
\name{crayon}
\alias{bgBlack}
\alias{bgBlue}
\alias{bgCyan}
\alias{bgGreen}
\alias{bgMagenta}
\alias{bgRed}
\alias{bgWhite}
\alias{bgYellow}
\alias{black}
\alias{blue}
\alias{blurred}
\alias{bold}
\alias{crayon}
\alias{crayon-package}
\alias{cyan}
\alias{green}
\alias{hidden}
\alias{inverse}
\alias{italic}
\alias{magenta}
\alias{red}
\alias{reset}
\alias{silver}
\alias{strikethrough}
\alias{underline}
\alias{white}
\alias{yellow}
\title{Colored terminal output}
\usage{
## Simple styles
red(...)
bold(...)
...

## See more styling below
}
\arguments{
\item{...}{Strings to style.}
}
\description{
With crayon it is easy to add color to terminal output, create styles
for notes, warnings, errors; and combine styles.
}
\details{
ANSI color support is automatically detected and used. Crayon was largely
inspired by chalk \url{https://github.com/sindresorhus/chalk}.

Crayon defines several styles, that can be combined. Each style in the list
has a corresponding function with the same name.
}
\section{Genaral styles}{


\itemize{
  \item reset
  \item bold
  \item blurred (usually called \sQuote{dim}, renamed to avoid name clash)
  \item italic (not widely supported)
  \item underline
  \item inverse
  \item hidden
  \item strikethrough (not widely supported)
}
}

\section{Text colors}{


\itemize{
  \item black
  \item red
  \item green
  \item yellow
  \item blue
  \item magenta
  \item cyan
  \item white
  \item silver (usually called \sQuote{gray}, renamed to avoid name clash)
}
}

\section{Background colors}{


\itemize{
  \item bgBlack
  \item bgRed
  \item bgGreen
  \item bgYellow
  \item bgBlue
  \item bgMagenta
  \item bgCyan
  \item bgWhite
}
}

\section{Styling}{


The styling functions take any number of character vectors as arguments,
and they concatenate and style them: \preformatted{  library(crayon)
  cat(blue("Hello", "world!\n"))
}

Crayon defines the \code{\%+\%} string concatenation operator, to make it easy
to assemble stings with different styles. \preformatted{  cat("... to highlight the " \%+\% red("search term") \%+\%
      " in a block of text\n")
}

Styles can be combined using the \code{$} operator: \preformatted{  cat(yellow$bgMagenta$bold('Hello world!\n'))
} See also \code{\link{combine_styles}}.

Styles can also be nested, and then inner style takes
precedence: \preformatted{  cat(green(
    'I am a green line ' \%+\%
    blue$underline$bold('with a blue substring') \%+\%
    ' that becomes green again!\n'
  ))
}

It is easy to define your own themes: \preformatted{  error <- red $ bold
  warn <- magenta $ underline
  note <- cyan
  cat(error("Error: subscript out of bounds!\n"))
  cat(warn("Warning: shorter argument was recycled.\n"))
  cat(note("Note: no such directory.\n"))
}
}
\examples{
cat(blue("Hello", "world!"))

cat("... to highlight the " \\\%+\\\% red("search term") \\\%+\\\%
    " in a block of text")

cat(yellow$bgMagenta$bold('Hello world!'))

cat(green(
 'I am a green line ' \\\%+\\\%
 blue$underline$bold('with a blue substring') \\\%+\\\%
 ' that becomes green again!'
))

error <- red $ bold
warn <- magenta $ underline
note <- cyan
cat(error("Error: subscript out of bounds!\\n"))
cat(warn("Warning: shorter argument was recycled.\\n"))
cat(note("Note: no such directory.\\n"))
}
\seealso{
\code{\link{make_style}} for using the 256 ANSI colors.
}

