% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_plot.R
\name{forest_plot}
\alias{forest_plot}
\title{Forest plot}
\usage{
forest_plot(
  data,
  facet_formula = "covname~paramname",
  xlabel = "",
  ylabel = "",
  x_facet_text_size = 13,
  y_facet_text_size = 13,
  x_facet_text_angle = 0,
  y_facet_text_angle = 0,
  x_facet_text_vjust = 0.5,
  y_facet_text_vjust = 0.5,
  x_facet_text_hjust = 0.5,
  y_facet_text_hjust = 0.5,
  xy_facet_text_bold = TRUE,
  x_label_text_size = 16,
  y_label_text_size = 16,
  break_ylabel = FALSE,
  y_label_text_width = 25,
  table_text_size = 7,
  base_size = 22,
  theme_benrich = FALSE,
  table_title = "",
  table_title_size = 15,
  ref_legend_text = "",
  area_legend_text = "",
  interval_legend_text = "",
  legend_order = c("pointinterval", "ref", "area", "shape"),
  combine_area_ref_legend = TRUE,
  legend_position = "top",
  show_ref_area = TRUE,
  ref_area = c(0.8, 1.25),
  show_ref_value = TRUE,
  ref_value = 1,
  ref_area_col = "#BEBEBE50",
  ref_value_col = "black",
  interval_col = "blue",
  bsv_col = "red",
  interval_bsv_text = "",
  strip_col = "#E5E5E5",
  paramname_shape = FALSE,
  legend_shape_reverse = FALSE,
  facet_switch = c("both", "y", "x", "none"),
  facet_scales = c("fixed", "free_y", "free_x", "free"),
  facet_space = c("fixed", "free_x", "free_y", "free"),
  facet_labeller = "label_value",
  label_wrap_width = 55,
  facet_labeller_multiline = FALSE,
  strip_placement = c("inside", "outside"),
  strip_outline = TRUE,
  facet_spacing = 5.5,
  major_x_ticks = NULL,
  minor_x_ticks = NULL,
  x_range = NULL,
  logxscale = FALSE,
  show_yaxis_gridlines = TRUE,
  show_xaxis_gridlines = TRUE,
  show_table_facet_strip = "none",
  table_facet_switch = c("both", "y", "x", "none"),
  show_table_yaxis_tick_label = FALSE,
  reserve_table_xaxis_label_space = TRUE,
  table_panel_border = TRUE,
  table_position = c("right", "below", "none"),
  plot_table_ratio = 4,
  vertical_dodge_height = 0.8,
  legend_space_x_mult = 1,
  legend_ncol_interval = 1,
  legend_ncol_shape = 1,
  plot_margin = c(5.5, 5.5, 5.5, 5.5),
  table_margin = c(5.5, 5.5, 5.5, 5.5),
  legend_margin = c(0, 0.1, -0.1, 0),
  parse_xlabel = FALSE,
  parse_ylabel = FALSE,
  return_list = FALSE
)
}
\arguments{
\item{data}{Data to use.}

\item{facet_formula}{Facet formula.}

\item{xlabel}{X axis title.}

\item{ylabel}{Y axis title.}

\item{x_facet_text_size}{Facet text size X.}

\item{y_facet_text_size}{Facet text size Y.}

\item{x_facet_text_angle}{Facet text angle X.}

\item{y_facet_text_angle}{Facet text angle Y.}

\item{x_facet_text_vjust}{Facet text vertical justification.}

\item{y_facet_text_vjust}{Facet text vertical justification.}

\item{x_facet_text_hjust}{Facet text horizontal justification.}

\item{y_facet_text_hjust}{Facet text horizontal justification.}

\item{xy_facet_text_bold}{Bold Facet text. Logical TRUE FALSE.}

\item{x_label_text_size}{X axis labels size.}

\item{y_label_text_size}{Y axis labels size.}

\item{break_ylabel}{Split Y axis labels into multiple lines. Logical FALSE TRUE.}

\item{y_label_text_width}{Number of characters to break Y axis labels.}

\item{table_text_size}{Table text size.}

\item{base_size}{theme_bw base_size for the plot and table.}

\item{theme_benrich}{apply Benjamin Rich's theming.}

\item{table_title}{with theme_benrich on what text to use for table title.}

\item{table_title_size}{table title size.}

\item{ref_legend_text}{Reference legend text.}

\item{area_legend_text}{Area legend text.}

\item{interval_legend_text}{Pointinterval Legend text.}

\item{legend_order}{Legend order. A four-element vector with the following
items ordered in your desired order: "pointinterval", "ref", "area", "shape".
if an item is absent the legend will be omitted.}

\item{combine_area_ref_legend}{Combine reference and area legends if they
share the same text?}

\item{legend_position}{where to put the legend: "top", "bottom","right","none"}

\item{show_ref_area}{Show reference window?}

\item{ref_area}{Reference area. Two-element numeric vector multiplying the ref_value.}

\item{show_ref_value}{Show reference line?}

\item{ref_value}{X intercept of reference line.}

\item{ref_area_col}{Reference area background color.}

\item{ref_value_col}{Reference line color.}

\item{interval_col}{Point range color. One value.}

\item{bsv_col}{BSV pointinterval color. One value.}

\item{interval_bsv_text}{BSV legend text.}

\item{strip_col}{Strip background color.}

\item{paramname_shape}{Map symbol to parameter(s)?}

\item{legend_shape_reverse}{TRUE or FALSE.}

\item{facet_switch}{Facet switch to near axis. Possible values: "both", "y",
"x", "none".}

\item{facet_scales}{Facet scales. Possible values: "free_y", "fixed",
"free_x", "free".}

\item{facet_space}{Facet spaces. Possible values: "fixed", "free_x",
"free_y", "free".}

\item{facet_labeller}{Facet Labeller. Default "label_value"
any other valid `facet_grid` labeller can be specified.}

\item{label_wrap_width}{How many characters before breaking the line. Numeric value.
any other valid `facet_grid` labeller can be specified.}

\item{facet_labeller_multiline}{break facet strips into multiple lines. Logical TRUE FALSE.}

\item{strip_placement}{Strip placement. Possible values: "inside", "outside".}

\item{strip_outline}{Draw rectangle around the Strip. Logical TRUE FALSE.}

\item{facet_spacing}{Control the space between facets in points.}

\item{major_x_ticks}{X axis major ticks. Numeric vector.}

\item{minor_x_ticks}{X axis minor ticks. Numeric vector.}

\item{x_range}{Range of X values. Two-element numeric vector.}

\item{logxscale}{X axis log scale. Logical TRUE FALSE.}

\item{show_yaxis_gridlines}{Draw the y axis gridlines. Logical TRUE FALSE.}

\item{show_xaxis_gridlines}{Draw the x axis gridlines. Logical TRUE FALSE.}

\item{show_table_facet_strip}{Possible values: "none", "both", "y", "x".}

\item{table_facet_switch}{Table facet switch to near axis. Possible values: "both", "y",
"x", "none".}

\item{show_table_yaxis_tick_label}{Show table y axis ticks and labels?}

\item{reserve_table_xaxis_label_space}{keep space for the x axis label to keep alignment.}

\item{table_panel_border}{Draw the panel border for the table. Logical TRUE FALSE.}

\item{table_position}{Table position. Possible values: "right", "below", "none".}

\item{plot_table_ratio}{Plot-to-table ratio. Suggested value between 1-5.}

\item{vertical_dodge_height}{Amount of vertical dodging to apply on segments and table text.}

\item{legend_space_x_mult}{Multiplier to adjust the spacing between legend items.}

\item{legend_ncol_interval}{Control the number of columns for the pointinterval legend.}

\item{legend_ncol_shape}{Control the number of columns for the shape legend.}

\item{plot_margin}{Control the white space around the main plot. Vector of four numeric values
for the top, right, bottom and left sides.}

\item{table_margin}{Control the white space around the table. Vector of four numeric values
for the top, right, bottom and left sides.}

\item{legend_margin}{Control the white space around the plot legend. Vector of four numeric values
for the top, right, bottom and left sides.}

\item{parse_xlabel}{treat xlabel as an expression. Logical FALSE TRUE.}

\item{parse_ylabel}{treat ylabel as an expression. Logical FALSE TRUE.}

\item{return_list}{What to return if True a list of the main and table plots is returned
instead of the gtable/plot.}
}
\description{
Produce forest plots to visualize covariate effects
}
\examples{
library(dplyr)
library(ggplot2)

# Example 1

plotdata <- get_sample_data("forest-plot-table.csv")
plotdata <- plotdata \%>\%
  mutate(midlabel = format(round(mid,2), nsmall = 2),
         lowerlabel = format(round(lower,2), nsmall = 2),
         upperlabel = format(round(upper,2), nsmall = 2),
         LABEL = paste0(midlabel, " [", lowerlabel, "-", upperlabel, "]"))
param <- "BZD AUC"
plotdata <-  filter(plotdata,paramname==param)
plotdata$covname <- reorder(plotdata$covname,plotdata$upper,FUN =max)
plotdata$label <- reorder(plotdata$label,plotdata$scen)
covs <- c("WEIGHT","AGE")
plotdata <-  filter(plotdata,covname\%in\%covs)
forest_plot(plotdata,
            ref_legend_text = "Reference (vertical line)",
            area_legend_text = "Reference (vertical line)",
            xlabel = paste("Fold Change in", param, "Relative to Reference"),
            logxscale = TRUE, major_x_ticks =c(0.1,1,1.5),
            show_ref_area = FALSE,
            facet_formula = "covname~.",
            facet_scales = "free_y",
            facet_space = "free_y",
            show_table_facet_strip = "none",
            table_position = "right",
            plot_table_ratio = 4)

# Example 2

plotdata <- get_sample_data("forest-plot-table.csv")
plotdata <- plotdata \%>\%
  mutate(midlabel = format(round(mid,2), nsmall = 2),
         lowerlabel = format(round(lower,2), nsmall = 2),
         upperlabel = format(round(upper,2), nsmall = 2),
         LABEL = paste0(midlabel, " [", lowerlabel, "-", upperlabel, "]"))
param <- c("BZD AUC","BZD Cmax")
plotdata <-  filter(plotdata,paramname\%in\%param)
plotdata <-  filter(plotdata,covname\%in\%"WEIGHT")
plotdata$covname <- reorder(plotdata$covname,plotdata$upper,FUN =max)
plotdata$label <- reorder(plotdata$label,plotdata$scen)
forest_plot(plotdata,
            ref_legend_text = "Reference (vertical line)",
            area_legend_text = "Reference (vertical line)",
            xlabel = paste("Fold Change of Parameter", "Relative to Reference"),
            show_ref_area = FALSE,
            facet_formula = "covname~paramname",
            facet_scales = "free_y",
            facet_space = "free_y",
            x_facet_text_size = 10,
            y_facet_text_size = 10,
            y_label_text_size = 10,
            y_label_text_width = 15,
            x_label_text_size = 10,
            facet_switch = "both",
            show_table_facet_strip = "both",
            show_table_yaxis_tick_label = TRUE,
            table_position = "below",
            plot_table_ratio = 1)
\dontrun{
# Example 3

plotdata <- get_sample_data("forestplotdatacpidata.csv")
forest_plot(plotdata,
            ref_area = c(0.8, 1.2),
            x_facet_text_size = 12,
            y_facet_text_size = 12,
            y_label_text_size = 10,
            x_label_text_size = 10,
            table_text_size = 6,
            plot_table_ratio = 1.5,
            ref_legend_text = "Reference (vertical line)\n+/- 20\% limits (colored area)",
            area_legend_text = "Reference (vertical line)\n+/- 20\% limits (colored area)",
            xlabel = "Fold Change Relative to RHZE",
            facet_formula = "covname~paramname",
            table_position = "below",
            show_table_facet_strip = "both",
            show_table_yaxis_tick_label = TRUE)

# Example 4
plotdata <- get_sample_data("dataforest.csv")
plotdata <- plotdata \%>\%
  mutate(midlabel = format(round(mid,2), nsmall = 2),
         lowerlabel = format(round(lower,2), nsmall = 2),
         upperlabel = format(round(upper,2), nsmall = 2),
         LABEL = paste0(midlabel, " [", lowerlabel, "-", upperlabel, "]"))
plotdata <- plotdata \%>\%
  filter(covname\%in\%c("Weight"))
plotdata$label <- as.factor(as.character(plotdata$label))
plotdata$label <- factor(plotdata$label, c("36.2 kg","66 kg","110 kg"))
forest_plot(plotdata,
            ref_area = c(0.8, 1.2),
            x_facet_text_size = 13,
            y_facet_text_size = 13,
            ref_legend_text = "Reference (vertical line)\n+/- 20\% limits (colored area)",
            area_legend_text = "Reference (vertical line)\n+/- 20\% limits (colored area)",
            xlabel = "Fold Change Relative to Parameter",
            facet_formula = "covname~paramname",
            facet_switch = "both",
            facet_scales = "free",
            facet_space = "fixed",
            table_position = "below",
            plot_table_ratio = 1,
            show_table_facet_strip = "both",
            show_table_yaxis_tick_label = TRUE)

# Example 5

forest_plot(plotdata,
            ref_area = c(0.8, 1.2),
            x_facet_text_size = 13,
            y_facet_text_size = 13,
            ref_legend_text = "Reference (vertical line)\n+/- 20\% limits (colored area)",
            area_legend_text = "Reference (vertical line)\n+/- 20\% limits (colored area)",
            xlabel = "Fold Change Relative to Parameter",
            facet_formula = "covname~.",
            facet_switch = "both",
            facet_scales = "free",
            facet_space = "fixed",
            paramname_shape = TRUE,
            table_position = "none",
            ref_area_col = rgb( col2rgb("gray50")[1], col2rgb("gray50")[2],col2rgb("gray50")[3],
            max = 255, alpha = 0.1*255 ) ,
            interval_col = "steelblue",
            strip_col = "lightblue",
            plot_table_ratio = 1)
}
}
