% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/Cort.R, R/CortForest.R,
%   R/cbCopula.R
\name{dCopula}
\alias{dCopula}
\alias{dCopula,matrix,Cort-method}
\alias{dCopula,matrix,CortForest-method}
\alias{dCopula,matrix,cbCopula-method}
\title{Copula density}
\usage{
dCopula(u, copula, ...)

\S4method{dCopula}{matrix,Cort}(u, copula)

\S4method{dCopula}{matrix,CortForest}(u, copula)

\S4method{dCopula}{matrix,cbCopula}(u, copula)
}
\arguments{
\item{u}{numeric matrix : one row per observation}

\item{copula}{the copula object}

\item{...}{other parameter to be passed to methods for this generic.}
}
\value{
the density of the copula on each observation
}
\description{
This function returns the density of a given copula on given observations.
}
\section{Functions}{
\itemize{
\item \code{dCopula,matrix,Cort-method}: Method for the class Cort

\item \code{dCopula,matrix,CortForest-method}: Method for the class CortForest

\item \code{dCopula,matrix,cbCopula-method}: Method for the cbCopula
}}

\examples{
cop <- cbCopula(LifeCycleSavings,m = 5)
dCopula(rep(0,5),cop)
dCopula(rep(0.5,5),cop)
dCopula(rep(1,5),cop)

}
