\name{fgmCopula-class}
\docType{class}
\alias{fgmCopula-class}
\title{Class "fgmCopula" }
\description{Multivariate Multiparameter Farlie-Gumbel-Morgenstern
  Copula.}
\section{Objects from the Class}{
  Objects can be created by calls of the form \code{new("fgmCopula",
    ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{exprdist}:}{Object of class \code{"expression"},
      expressions for the cdf and pdf of the copula. These expressions
      are used in function \code{pCopula()} and \code{dCopula()}.}
     \item{\code{dimension}:}{Object of class \code{"numeric"}, the
      dimension of the copula. }
    \item{\code{parameters}:}{Object of class \code{"numeric"},
      parameter values. }
    \item{\code{param.names}:}{Object of class \code{"character"},
      parameter names. }
    \item{\code{param.lowbnd}:}{Object of class \code{"numeric"},
      parameter lower bound. }
    \item{\code{param.upbnd}:}{Object of class \code{"numeric"},
      parameter upper bound. }
    \item{\code{fullname}:}{Object of class \code{"character"}, family names
      of the copula. }
  }
}
\section{Methods}{
  \describe{
    \item{dCopula}{\code{signature(copula = "fgmCopula")}: ... }
    \item{pCopula}{\code{signature(copula = "fgmCopula")}: ... }
    \item{rCopula}{\code{signature(copula = "fgmCopula")}: ... }
  }
}
\section{Extends}{
  Class \code{"fgmCopula"} extends class \code{"\linkS4class{copula}"} directly.
}
%\author{Ivan Kojadinovic and Jun Yan}
\references{
  Nelsen, R. B. (2006), \emph{An introduction to Copulas}, Springer, New York.
}
\note{
  The verification of the validity of the parameter values is of high
  complexity and may not work for high dimensional copulas.

  The random number generation needs to be properly tested, especially
  for dimensions higher than 2.
}
\seealso{
  \code{\link{copula-class}}, \code{\link{fgmCopula-class}}.
}
\keyword{classes}
