% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerstress.R
\name{powerStressFast}
\alias{powerStressFast}
\title{Power stress minimization by NEWUOA}
\usage{
powerStressFast(
  delta,
  kappa = 1,
  lambda = 1,
  nu = 1,
  weightmat = 1 - diag(nrow(delta)),
  init = NULL,
  ndim = 2,
  acc = 1e-12,
  itmax = 50000,
  verbose = FALSE
)
}
\arguments{
\item{delta}{dist object or a symmetric, numeric data.frame or matrix of distances}

\item{kappa}{power of the transformation of the fitted distances; defaults to 1}

\item{lambda}{the power of the transformation of the proximities; defaults to 1}

\item{nu}{the power of the transformation for weightmat; defaults to 1}

\item{weightmat}{a matrix of finite weights}

\item{init}{starting configuration}

\item{ndim}{dimension of the configuration; defaults to 2}

\item{acc}{The smallest value of the trust region radius that is allowed. If not defined, then 1e-10 will be used.}

\item{itmax}{maximum number of iterations. Default is 50000.}

\item{verbose}{should iteration output be printed; if > 1 then yes}
}
\value{
a smacofP object (inheriting form smacofB, see \code{\link{smacofSym}}). It is a list with the components
\itemize{
\item delta: Observed dissimilarities, not normalized
\item obsdiss: Observed dissimilarities, normalized 
\item confdist: Configuration dissimilarities, NOT normalized 
\item conf: Matrix of fitted configuration, NOT normalized
\item stress: Default stress (stress 1, square root of the explicitly normalized stress on the normalized, transformed dissimilarities)  
\item spp: Stress per point (based on stress.en) 
\item ndim: Number of dimensions
\item model: Name of smacof model
\item niter: Number of iterations
\item nobj: Number of objects
\item type: Type of MDS model
}
and some additional components
\itemize{
\item gamma: Empty
\item stress.m: default stress for the COPS and STOP. Defaults to the explicitly normalized stress on the normalized, transformed dissimilarities
\item stress.en: explicitly stress on the normalized, transformed dissimilarities and normalized transformed distances
\item deltaorig: observed, untransformed dissimilarities
\item weightmat: weighting matrix 
}
}
\description{
An implementation to minimize power stress by a derivative-free trust region optimization algorithm (NEWUOA). Much faster than majorizing as used in powerStressMin but perhaps less accurate.
}
\examples{
dis<-smacof::kinshipdelta
res<-powerStressFast(as.matrix(dis),kappa=2,lambda=1.5)
res
summary(res)
plot(res)

}
\seealso{
\code{\link{smacofSym}}
}
