% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go_indica_fi.R
\name{go_indica_fi}
\alias{go_indica_fi}
\title{Create an indicator fiche for a given aggregation of countries.}
\usage{
go_indica_fi(
  time_0 = NA,
  time_t = NA,
  timeName = NA,
  workDF = NA,
  indicaT = NA,
  indiType = c("highBest", "lowBest")[1],
  seleMeasure = "all",
  seleAggre = "EU27",
  x_angle = 45,
  data_res_download = FALSE,
  auth = "A.Student",
  dataNow = Sys.time(),
  outFile = NA,
  outDir = NA,
  pdf_out = FALSE,
  workTB = NULL,
  selfContained = FALSE
)
}
\arguments{
\item{time_0}{starting time.}

\item{time_t}{ending time.}

\item{timeName}{name of the variable containing times (years).}

\item{workDF}{name (string) of the dataset in the global environment containing
all countries contributing to average.}

\item{indicaT}{name of the  considered indicator.}

\item{indiType}{type of indicator "lowBest" or "highBest" (default).}

\item{seleMeasure}{set of measures of convergence; this is a
subset of the following collection of strings: "beta","delta",
 "gamma","sigma"; "all" is a shortcut for the whole set.}

\item{seleAggre}{selection of member states, default 'EU27' ('custom'
if not pre-coded).}

\item{x_angle}{axis orientation for time labels, default 45.}

\item{data_res_download}{should data and results be downloaded, default FALSE.}

\item{auth}{author of this report, default 'A.Student'.}

\item{dataNow}{date of production of this country fiche, default is
current time.}

\item{outFile}{name of the output file (without path), without extension.}

\item{outDir}{output directory, eventually not existing (only one level allowed).}

\item{pdf_out}{should the output be saved as PDF file? The default is  FALSE.}

\item{workTB}{a tibble containing data.}

\item{selfContained}{TRUE if just one file is desired}
}
\value{
No return value, called for side effects.
}
\description{
An auxiliary function to compile a rmarkdown file to produce the indicator fiche in
html format within the output directory.
}
\details{
Note that most of function arguments are passed as strings of characters
instead of object names. For example, if the object of a dataset
in the workspace is myTB, the parameter is set like  workDF='myTB'
instead of workDF=myTB as one may expect.
Furthermore, the dataset must be complete, that is without missing values.
Note also that Internet connection should be available when invoking the function
to properly rendering the results in the html file. The fiches have been tested with
the browsers Mozilla Firefox and Google Chrome.
}
\references{
{\url{https://unimi2013-my.sharepoint.com/:u:/g/personal/federico_stefanini_unimi_it/EW0cVSIgbtZAvLPNbqcxdX8Bfn5VGSRHfAH88hQwc_RIEQ?e=MgtSZu}}
}
