% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_data.R
\name{check_data}
\alias{check_data}
\title{Make tests on a dataset (dataframe and tibbles)}
\usage{
check_data(tavDes, timeName = NA)
}
\arguments{
\item{tavDes}{the dataframe under examination}

\item{timeName}{a string with the name of the time  variable, optional}
}
\value{
an object stating if errors are present
}
\description{
A dataset can't have qualitative variables, neither vector of strings
nor missing values for computing convergence measures.
A time variable should also be present, and if the name is passed
then a check on the time order is performed.
The object returned states if the dataset is ready for calculations, and
if it is not, the error component states why checking failed.
}
\examples{

# Example 1
# Tibble dataset with missing values:
require(tibble)
myTB1  <- tibble::tribble(
~time, ~veval,
1988,   1201,
1989,    NA,
1990,   998,
1991,    NA
)
# Check dataset:
check_data(myTB1)

# Example 2
# Dataset with no missing values, no qualitative variables, and variable time present:
myTB2  <- tibble::tribble(
~time, ~veval,
1988,   1201,
1989,    450,
1990,   998,
1991,   675
)
check_data(myTB2)

# Check the "emp_20_64_MS" Eurofound dataset:
data(emp_20_64_MS)
check_data(emp_20_64_MS, timeName="time")

}
\references{
{ \url{https://local.disia.unifi.it/stefanini/RESEARCH/coneu/tutorial-conv.html}}
}
