% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probMat.R
\name{rprobMat}
\alias{rprobMat}
\alias{rcondProbMat}
\title{Generate matrix of (conditional) probability distributions}
\usage{
rprobMat(n, dim, d, alpha = 1)

rcondProbMat(n, dim, d, alpha = 1, condition)
}
\arguments{
\item{n}{number of distributions}

\item{dim}{dimension of contingency table for distributions}

\item{d}{number of dimensions of table}

\item{alpha}{parameter to use in dirichlet distribution}

\item{condition}{which dimensions should be conditioned upon}
}
\value{
A \code{tables} object containing random distributions.
}
\description{
Generates discrete probability distributions in a matrix.
}
\details{
Returns an object of class \code{tables} consisting of 
discrete probability distributions.  Each distribution is assumed to be a 
contingency table of dimension \code{dim}, and the probabilities
are generated using a Dirichlet distribution with parameters all 
equal to \code{alpha}.
}
\section{Functions}{
\itemize{
\item \code{rcondProbMat}: Random conditional distributions
}}

\examples{
dat <- rprobMat(10, c(2,2,2))

}
