Conjoint<-function(y,x,z,y.type="score")
{
	if (y.type=="rank") {y<-caRankToScore(y)}
	options(contrasts=c("contr.sum","contr.poly"))
	outdec<-options(OutDec="."); on.exit(options(outdec))
	options(OutDec=",")	
	utls<-round(caUtilities(y,x,z),4)
	levnms<-c("intercept",as.matrix(z))
	lu<-cbind(levnms,utls)
	Utls<-as.data.frame(lu)
	print("Part worths (utilities) of levels (model parameters for whole sample):")
	print(Utls)
	imp<-round(caImportance(y,x),2)
	print("Average importance of factors (attributes):")
	print(imp)
	print(paste("Sum of average importance: ", sum(imp)), quote=FALSE)
	print("Chart of average factors importance")
	dev.new(width=5,height=5,pointsize=9)
	barplot(imp,ylim=c(0,100),ylab="Average importance",xlab="Factors",names.arg=names(x))
}