% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record.R
\name{cong_record}
\alias{cong_record}
\title{Request Bill Information}
\usage{
cong_record(
  year = NULL,
  month = NULL,
  day = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{year}{integer for year}

\item{month}{integer for month}

\item{day}{integer for day of month}

\item{limit}{number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{xml} or \code{json}.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or requested \code{format}.}
}
\value{
\code{tibble} or HTTP response if \code{clean = FALSE}
}
\description{
Request Bill Information
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Requires API Key

cong_record()

cong_record(year = 2022, month = 6, day = 28)
\dontshow{\}) # examplesIf}
}
