% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{cs_get_data}
\alias{cs_get_data}
\title{Download Crime Data from SLMPD}
\usage{
cs_get_data(year, month, index)
}
\arguments{
\item{year}{A year value in the style \code{YYYY}}

\item{month}{Optional; a month number, name, or abbreviation - \code{1},
\code{"Jan"}, and \code{"January"} are all acceptible inputs.}

\item{index}{Optional; an index object created with \code{\link{cs_create_index}}.
Building the index prior to downloading data, especially if you are downloading
multiple years worth of data, will result in dramatically faster execution
times for this function.}
}
\value{
A year-list object ready for validation.
}
\description{
Downloads crime data from the SLMPD website.
}
\examples{
\donttest{
# create index
i <- cs_create_index()

# download single month
may18 <- cs_get_data(year = 2018, month = "May", index = i)

# preview single month
may18

# download full year
yearList18 <- cs_get_data(year = 2018, index = i)

# preview year list object
yearList18
}

}
