% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{snooker_players}
\alias{snooker_players}
\title{Snooker players}
\format{A \link[tibble:tibble]{tibble} with one row per player and the following
columns:
\itemize{
\item \strong{id} <int> : Player identifier in snooker.org database (used in
\code{player1Id}, \code{player2Id} and \code{winnerId} columns of \link{snooker_matches}).
\item \strong{name} <chr> : Player full name.
\item \strong{nationality} <chr> : Player nationality.
\item \strong{sex} <chr> : Player gender ("F" for female, "M" for male, and
"Unknown").
\item \strong{born} <dttm> : Player date of birth.
\item \strong{status} <chr> : Player status in season 2017/2018 ("pro" for
professional, "ama" for amateur).
}}
\usage{
snooker_players
}
\description{
Data set describing snooker players in seasons 2016/2017 and 2017/2018.
}
\details{
Data is taken from snooker.org (http://www.snooker.org/) API.

Data is present only for players who played at least one game in tracked
\link[=snooker_events]{snooker events} in seasons 2016/2017 and 2017/2018.
}
\seealso{
\link[=snooker_events]{Snooker events}, \link[=snooker_matches]{snooker matches}
}
\keyword{datasets}
