% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/offense-defense.R
\name{offense-defense}
\alias{offense-defense}
\alias{rate_od}
\alias{rank_od}
\title{Offense-Defense method}
\usage{
rate_od(cr_data, ..., force_nonneg_h2h = TRUE, eps = 0.001, tol = 1e-04,
  max_iterations = 100)

rank_od(cr_data, ..., force_nonneg_h2h = TRUE, eps = 0.001, tol = 1e-04,
  max_iterations = 100, keep_rating = FALSE, ties = c("average", "first",
  "last", "random", "max", "min"), round_digits = 7)
}
\arguments{
\item{cr_data}{Competition results in format ready for
\link[comperes:as_longcr]{as_longcr()}.}

\item{...}{Head-to-Head expression (see \link[comperes:h2h_mat]{h2h_mat()}).}

\item{force_nonneg_h2h}{Whether to force nonnegative values in Head-to-Head
matrix.}

\item{eps}{Coefficient for total support.}

\item{tol}{Tolerance value for iterative algorithm.}

\item{max_iterations}{Maximum number of iterations for iterative algorithm.}

\item{keep_rating}{Whether to keep rating columns in ranking output.}

\item{ties}{Value for \code{ties} in \code{\link[=round_rank]{round_rank()}}.}

\item{round_digits}{Value for \code{round_digits} in \code{\link[=round_rank]{round_rank()}}.}
}
\value{
\code{rate_od()} returns a \link[tibble:tibble]{tibble} with the following
columns:
\itemize{
\item \strong{player} - player identifier.
\item \strong{rating_off} - offensive \link[=rating-ranking]{rating} of player. \strong{Bigger
value indicates better player performance}.
\item \strong{rating_def} - defensive rating of player. \strong{Smaller value indicates
better player performance}.
\item \strong{rating_od} - Offense-Defense rating of player. \strong{Bigger value indicates
better player performance}.
}

\code{rank_od()} returns a \code{tibble} of the similar structure as \code{rate_od()}:
\itemize{
\item \strong{player} - player identifier.
\item \strong{rating_off}, \strong{rating_def}, \strong{rating_od} - ratings (if
\code{keep_rating = TRUE}).
\item \strong{ranking_off}, \strong{ranking_def}, \strong{ranking_od} -
\link[=rating-ranking]{rankings} computed with \code{\link[=round_rank]{round_rank()}}.
}
}
\description{
Functions to compute \link[=rating-ranking]{rating} and \link[=rating-ranking]{ranking}
using Offense-Defense method.
}
\details{
Offense-Defense (OD) rating is designed for games in which player's
goal is to make higher score than opponent(s). To describe competition
results Head-to-Head matrix is computed using \code{...} (see
\link[comperes:h2h_mat]{h2h_mat()} for technical details and section \strong{Design
of Head-to-Head values} for design details). For pairs of players without
common games Head-to-Head value is computed to 0 (not \code{NA}). \strong{Note} that
values should be non-negative and non-NA. This can be ensured with setting
\code{force_nonneg_h2h} to \code{TRUE}.

For player which can achieve \emph{high} Head-to-Head value (even against the
player with strong defense) it is said that he/she has \strong{strong offense}
which results into \emph{high} offensive rating. For player which can force their
opponents into achieving \emph{low} Head-to-Head value (even if they have strong
offense) it is said that he/she has \strong{strong defense} which results into
\emph{low} defensive rating.

Offensive and defensive ratings describe different skills of players. In
order to fully rate players, OD ratings are computed: offensive ratings
divided by defensive. The more OD rating the better player performance.

Algorithm for OD ratings is as follows:
\enumerate{
\item Compute Head-to-Head matrix using \code{...}.
\item Add small value to Head-to-Head matrix to ensure convergence of the
iterative algorithm in the next step. If all values are strictly positive
then this step is omitted. In other case small value is computed as the
smallest non-zero Head-to-Head value multiplied by \code{eps}.
\item Perform iterative fixed point search with the following recurrent formula:
\code{def_{k+1} = t(A) \%*\% inv(A \%*\% inv(def_{k}))} where \code{def_{k}}
is a vector of defensive ratings at iteration \code{k}, \code{A} is a perturbed
Head-to-Head matrix, \code{inv(x) = 1 / x}. Iterative search stops if at least one
of two conditions is met:
\itemize{
\item \code{sum(abs(def_{k+1} / def_{k} - 1)) < tol}.
\item Number of iterations exceeds maximum number of iterations
\code{max_iterations}.
}
\item Compute offensive ratings: \code{off = A \%*\% inv(def)}.
\item Compute OD ratings: \code{od = off / def}.
}

Ratings are computed based only on games between players of interest (see
Players). However, be careful with OD ratings for players with no games:
they will have weak offense (because they "scored" 0 in all games) but
strong defense (because all their opponents also "scored" 0 in all common
games). Therefore accounting for missing players might be not a very good
idea.
}
\section{Design of Head-to-Head values}{


Head-to-Head values in these functions are assumed to follow the property
which can be \emph{equivalently} described in two ways:
\itemize{
\item In terms of \link[comperes:h2h_mat]{matrix format}: \strong{the more Head-to-Head
value in row \emph{i} and column \emph{j} the better player from row \emph{i} performed than
player from column \emph{j}}.
\item In terms of \link[comperes:h2h_long]{long format}: \strong{the more Head-to-Head
value the better player1 performed than player2}.
}

This design is chosen because in most competitions the goal is to score
\strong{more points} and not less. Also it allows for more smooth use of
\link[comperes:h2h_funs]{h2h_funs} from \code{comperes} package.
}

\section{Players}{


\code{comperank} offers a possibility to handle certain set of players. It is done
by having \code{player} column (in \link[comperes:as_longcr]{longcr} format) as factor
with levels specifying all players of interest. In case of factor the result
is returned only for players from its levels. Otherwise - for all present
players.
}

\examples{
rate_od(ncaa2005, mean(score1))

rank_od(ncaa2005, mean(score1))

rank_od(ncaa2005, mean(score1), keep_rating = TRUE)

# Account for self play
rate_od(ncaa2005, if(player1[1] == player2[1]) 0 else mean(score1))

}
\references{
Amy N. Langville, Carl D. Meyer (2012) \emph{Who’s #1?: The
science of rating and ranking}.

Philip A. Knight (2008) \emph{The Sinkhorn-Knopp algorithm:
Convergence and applications.}. SIAM Journal of Matrix Analysis,
30(1):261–275, 2008 (For stopping rule of iterative algorithm).
}
