% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterative.R
\name{iterative}
\alias{iterative}
\alias{rate_iterative}
\alias{rank_iterative}
\alias{add_iterative_ratings}
\title{Iterative rating method}
\usage{
rate_iterative(cr_data, rate_fun, initial_ratings = 0)

rank_iterative(cr_data, rate_fun, initial_ratings = 0, keep_rating = FALSE,
  type = "desc", ties = c("average", "first", "last", "random", "max",
  "min"), round_digits = 7)

add_iterative_ratings(cr_data, rate_fun, initial_ratings = 0)
}
\arguments{
\item{cr_data}{Competition results in format ready for
\link[comperes:as_longcr]{as_longcr()}.}

\item{rate_fun}{Rating function (see Details).}

\item{initial_ratings}{Initial ratings (see Details).}

\item{keep_rating}{Whether to keep rating column in ranking output.}

\item{type}{Value for \code{type} in \code{\link[=round_rank]{round_rank()}}: \code{"desc"} or \code{"asc"}.}

\item{ties}{Value for \code{ties} in \code{\link[=round_rank]{round_rank()}}.}

\item{round_digits}{Value for \code{round_digits} in \code{\link[=round_rank]{round_rank()}}.}
}
\value{
\code{rate_iterative()} returns a \link[tibble:tibble]{tibble} with columns
\code{player} (player identifier) and \code{rating_iterative} (Iterative
\link[=rating-ranking]{ratings}, based on row order, by the end of competition
results). \strong{Interpretation of numbers depends on rating function
\code{rate_fun}}.

\code{rank_iterative()} returns a \code{tibble} with columns \code{player},
\code{rating_iterative} (if \code{keep_rating = TRUE}) and \code{ranking_iterative}
(Iterative \link[=rating-ranking]{ranking} computed with \code{\link[=round_rank]{round_rank()}} based on
specified \code{type}).

\code{add_iterative_ratings()} returns a \link[comperes:widecr]{widecr} form of
\code{cr_data} with four rating columns added:
\itemize{
\item \strong{rating1Before} - Rating of player1 before the game.
\item \strong{rating2Before} - Rating of player2 before the game.
\item \strong{rating1After} - Rating of player1 after the game.
\item \strong{rating2After} - Rating of player2 after the game.
}
}
\description{
Functions to compute Iterative numeric \link[=rating-ranking]{ratings}, i.e. which
are recomputed after every game, and corresponding
\link[=rating-ranking]{rankings}.
}
\details{
Iterative ratings of group of players are recomputed after every
game based on players' game scores and their ratings just before the game.
Theoretically this kind of ratings can be non-numeric and be computed on
competition results with variable number of players but they rarely do. This
package provides functions for computing iterative \strong{numeric} ratings for
\link[comperes:to_pairgames]{pairgames} (competition results with games only
between two players). Error is thrown if \code{cr_data} is not pairgames.

Games in \link[comperes:widecr]{widecr} form are arranged in increasing order
of values in column \code{game} (if it is present) and processed from first to
last row.

\code{NA} values in column \code{player} are allowed. These players are treated as
'ghosts': players of the same rating as opponent before the game. 'Ghosts'
are not actual players so they don't appear in the output of
\code{rate_iterative()}. For games between two 'ghosts' ratings before and after
the game are set to 0.

The core of the rating system is \code{rate_fun}. It should take the
following arguments:
\itemize{
\item \strong{rating1} - Rating of player1 before the game.
\item \strong{score1} - Score of player1 in the game.
\item \strong{rating2} - Rating of player2 before the game.
\item \strong{score2} - Score of player2 in the game.
}

\code{rate_fun} should return a numeric vector of length 2: first element being a
rating of player1 after the game, second - of player2.

Ratings are computed based only on games between players of interest (see
Players) and \code{NA} values.

Initial ratings should be defined with argument \code{initial_ratings}. It
can be:
\itemize{
\item A single numeric value. In this case initial ratings for all players are
set to this value.
\item A named vector of ratings. All non-\code{NA} players, for which rating is
computed, should be present in its names (as character representation of
players' actual identifiers).
\item A data frame with first column representing player and second - initial
rating. It will be converted to named vector with
\link[tibble:deframe]{deframe()} from \code{tibble} package.
}
}
\section{Players}{


\code{comperank} offers a possibility to handle certain set of players. It is done
by having \code{player} column (in \link[comperes:as_longcr]{longcr} format) as factor
with levels specifying all players of interest. In case of factor the result
is returned only for players from its levels. Otherwise - for all present
players.
}

\examples{
test_rate_fun <- function(rating1, score1, rating2, score2) {
  c(rating1, rating2) + ((score1 >= score2) * 2 - 1) * c(1, -1)
}
set.seed(1002)
cr_data <- data.frame(
  game = rep(1:10, each = 2),
  player = rep(1:5, times = 4),
  score = runif(20)
)
cr_data$player[c(6, 8)] <- NA

# Different settings of add_iterative_ratings
add_iterative_ratings(cr_data, test_rate_fun)

add_iterative_ratings(cr_data, test_rate_fun, initial_ratings = 10)

add_iterative_ratings(
  cr_data, test_rate_fun,
  initial_ratings = c("1" = 1, "2" = 2, "3" = 3, "4" = 4, "5" = 5)
)

add_iterative_ratings(
  cr_data, test_rate_fun,
  initial_ratings = data.frame(1:5, 0:4)
)

# Ratings and ranking at the end of competition results.
rate_iterative(cr_data, test_rate_fun)

rank_iterative(cr_data, test_rate_fun, type = "desc")

rank_iterative(cr_data, test_rate_fun, type = "desc", keep_rating = TRUE)

}
