\name{commentQuestions}
\alias{commentQuestions}
\title{ Apply a Commenting Scheme }
\description{
  This function applies a commenting scheme to a set of comparisons
  to produce a set of comments.
}
\usage{
commentQuestions(result, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{result}{ A set of comparison results, as generated by the
    \code{compareFiles()} function. }
  \item{\dots}{ One or more commenting schemes, as generated by the
    \code{questionComments()} function. }
}
\value{
  A matrix of comments.
}
\author{ Paul Murrell }
\seealso{
  \code{\link{questionComments}} and 
  \code{\link{compareFiles}}
}
\examples{
modelNames <- c("id", "age", 
                "edu", "class", 
                "IndianMothers")
files <- list.files(system.file("example", package="compare"),
                    pattern="^student[0-9]+[.]R$",
                    full.names=TRUE)

results <- compareFiles(files,
                        modelNames,
                        system.file("example", "model.R", package="compare"),
                        allowAll=TRUE,
                        resultNames=gsub(".+[/]|[.]R", "", files))
q1comments <- questionComments(c("id", "age", "edu", "class"),
                               comments("class",
                                        transformComment("coerced",
                                                         "'class' is a factor!")))
commentQuestions(results, q1comments)
}
\keyword{utilities}
\keyword{logic}
