% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcSolarGain.r
\name{calcSolarGain}
\alias{calcSolarGain}
\alias{calcsolargain}
\alias{SolarGain}
\alias{solargain}
\title{Solar Gain}
\usage{
calcSolarGain(solAlt, solAzi, solRadDir, solTrans,
 fSvv, fBes, asw=0.7, posture="seated", floorRef=0.6)
}
\arguments{
\item{solAlt}{a numeric value presenting solar altitude, degrees from horizontal in [degree C]}

\item{solAzi}{a numeric value presenting solar azimuth, degrees clockwise from North in [degree C]}

\item{solRadDir}{a numeric value presenting direct-beam solar radiation [W/m2]}

\item{solTrans}{a numeric value presenting total solar transmittance. Ranges from 0 to 1.}

\item{fSvv}{a numeric value presenting fraction of sky vault exposed to body. Ranges from 0 to 1.}

\item{fBes}{a numeric value presenting fraction of the possible body surface exposed to sun. Ranges from 0 to 1.}

\item{asw}{a numeric value presenting the average short-wave absorptivity of the occupant.}

\item{posture}{a list of available options 'standing', 'supine' or 'seated'.}

\item{floorRef}{a numeric value presenting floor reflectance. Usually assumed to be constant and equal to 0.6.}
}
\value{
An array of two values
First values represents \code{erf} - Net energy flux to or from the human body using the Effective Radiant Field [W/m2]
Second value represents \code{delMrt} - Delta mean radiant temperature, the increase 
in radiant temperature required without solar radiation [Degree C]
}
\description{
Function to calculate effective radiant field and delta mean radiant temperature.
}
\examples{
calcSolarGain(0, 120, 800, 0.5, 0.5, 0.5, asw=0.7, posture="seated") # Returns [42.9, 10.3]
}
\references{
Original code in Python by Tartarini & Schiavon (2020) <doi:10.1016/j.softx.2020.100578>
}
\seealso{
see also \code{\link{calcComfInd}}
}
\author{
Code implemented in to R by Shaomi Rahman. Further contribution by Marcel Schweiker.
}
