% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorpatch_impl.R
\name{OptimizeBiColor}
\alias{OptimizeBiColor}
\title{Optimizes a bicolor palette}
\usage{
OptimizeBiColor(neg.col.min = colorspace::sRGB(0, 0.01, 0),
  neg.col.max = colorspace::sRGB(0, 1, 0),
  pos.col.min = colorspace::sRGB(0.01, 0, 0),
  pos.col.max = colorspace::sRGB(1, 0, 0), center.col = colorspace::sRGB(0,
  0, 0), n.out = 64, oversampling = 128,
  col.dist.fun = DistColorFun("LAB"), reverse = FALSE)
}
\arguments{
\item{neg.col.min}{color representing the negative mininum value}

\item{neg.col.max}{color representing the negative maximum value}

\item{pos.col.min}{color for the positive minimum value}

\item{pos.col.max}{color representing the positive maximum value}

\item{center.col}{center color which maps to 0 (default: black)}

\item{n.out}{size of each half-palette}

\item{oversampling}{the oversampling rate}

\item{col.dist.fun}{color distance function (default: DistColorFun("LAB")) for
optimizing the palette}

\item{reverse}{shall the palette be searched starting from the minimum color to the maximum
(\code{reverse=FALSE}) or vice versa - defaults to \code{FALSE}}
}
\value{
bicolor palette
}
\description{
Optimizes a bicolor palette
}
\examples{
pal <- OptimizeBiColor(n.out = 8, oversampling = 32)
PlotUniformity(pal)
}
