% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{stdev_transform}
\alias{stdev_transform}
\title{Translate Standard Deviation from the Natural Scale to the Log or Logit Scale}
\usage{
stdev_transform(mu, sigma, dist)
}
\arguments{
\item{mu}{The mean of the distribution on the natural scale.}

\item{sigma}{The standard devation of the distribution on the natural scale.}

\item{dist}{The distribution to which the standard deviation should be transformed.}
}
\value{
The standard deviation translated to the log or logit scale.
}
\description{
This function changes a given standard deviation so that when a vector of samples is drawn from the given distribution,
the original standard deviation will be recovered once it is back-transformed from the log or logit scale. In effect,
the function "translates" a standard deviation from the natural scale to the log or logit scale for the purposes of
random draws from a probability distribution.
}
\examples{
mean <- 10
stdev <- 2
mean_trans <- log(mean)
stdev_trans <- stdev_transform(mean, stdev, "log")
draws <- rnorm(50, mean_trans, stdev_trans)
natural_scale <- exp(draws)
mean(draws)
sd(draws)
}
