% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_noise.R
\name{raw_noise_loop}
\alias{raw_noise_loop}
\title{Generate Autocorrelated Noise for Every Combination of the Given Parameters.}
\usage{
raw_noise_loop(timesteps, mu, sigma, phi, replicates)
}
\arguments{
\item{timesteps}{How many timesteps you want in each set. Can be scalar or
vector.}

\item{mu}{The mean of the temporally autocorrelated random numbers. Can be
scalar or vector.}

\item{sigma}{The standard deviation of the temporally autocorrelated random
numbers. Can be scalar or vector.}

\item{phi}{The temporal autocorrelation. 0 is white noise (uncorrelated),
positive values are red noise (correlated) and negative values are blue
noise (inversely correlated). Can be scalar or vector.}

\item{replicates}{How many replicates you would like of each possible
combination of parameters.}
}
\value{
A list of vectors of temporally autocorrelated random numbers. Each
  element in the list is named with the combination of parameters that
  generated it.
}
\description{
This function generates sets of temporally autocorrelated random numbers for
every possible combination of parameter values you specify. Essentially a
loop of \code{\link{raw_noise}} that outputs a list. All parameters can be
given as single values or vectors of values.
}
\examples{
loop <- raw_noise_loop(timesteps=c(5:10), mu=c(0.2, 0.5), sigma=c(0.2, 0.5),
                       phi=c(0, 0.1), replicates=10)
loop[[1]]
}
