% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_noise.R
\name{raw_estim_loop}
\alias{raw_estim_loop}
\title{Simulation and Estimation of Colored Noise}
\usage{
raw_estim_loop(timesteps, mu, sigma, phi, replicates)
}
\arguments{
\item{timesteps}{How many timesteps you want in each set. Can be scalar or
vector.}

\item{mu}{The mean of the temporally autocorrelated random numbers. Can be
scalar or vector.}

\item{sigma}{The standard deviation of the temporally autocorrelated random
numbers. Can be scalar or vector.}

\item{phi}{The temporal autocorrelation. 0 is white noise (uncorrelated),
positive values are red noise (correlated) and negative values are blue
noise (inversely correlated). Can be scalar or vector.}

\item{replicates}{How many replicates you would like of each possible
combination of parameters.}
}
\value{
A data frame with one row for each set of random numbers. The
  variables are mean, SD, autocorrelation, and the four parameters used to
  generate the random numbers.
}
\description{
This function simulates generates sets of temporally autocorrelated random
numbers for every possible combination of parameter values you specify, then
estimates the mean, standard deviation, and autocorrelation of each set of
random numbers so generated. Internally, the function does the same thing as
\code{\link{raw_noise_loop}}, but instead of outputting the random numbers, it
outputs measures of each set of random numbers.
}
\examples{
estimates <- raw_estim_loop(timesteps=c(5:10), mu=c(0.2, 0.5), sigma=c(0.2, 0.5),
                            phi=c(0, 0.1), replicates=10)
head(estimates)
}
