% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{autocorrelation}
\alias{autocorrelation}
\title{Estimate the Temporal Autocorrelation of a Numeric Vector.
A wrapper for the \code{\link[stats]{acf}} function from the stats package that
extracts only the temporal autocorrelation at a lag of one timestep (which is
the type of temporal autocorrelation that this package simulates).}
\usage{
autocorrelation(x, na.action = na.pass)
}
\arguments{
\item{x}{A numeric vector.}

\item{na.action}{The way the function will handle NAs in the vector. Set to \code{\link[stats]{na.pass}} by default.}
}
\value{
A single numeric value: the estimate of the temporal autocorrelation with a lag of 1.
}
\description{
Estimate the Temporal Autocorrelation of a Numeric Vector.
A wrapper for the \code{\link[stats]{acf}} function from the stats package that
extracts only the temporal autocorrelation at a lag of one timestep (which is
the type of temporal autocorrelation that this package simulates).
}
\examples{
rednoise <- raw_noise(timesteps = 50, mu = 0.5, sigma = 0.2, phi = 0.3)
autocorrelation(rednoise)
}
