% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order.R
\name{f_rsquared}
\alias{f_rsquared}
\title{R-squared between a response and a predictor}
\usage{
f_rsquared(x, y, df)
}
\arguments{
\item{x}{(required, character string) name of the predictor variable.}

\item{y}{(required, character string) name of the response variable}

\item{df}{(required, data frame) data frame with the columns 'x' and 'y'.}
}
\value{
R-squared
}
\description{
Computes the R-squared between a response and a predictor.
Fastest option to compute preference order.
}
\examples{

data(vi)

#subset to limit example run time
vi <- vi[1:1000, ]

f_rsquared(
  x = "growing_season_length", #predictor
  y = "vi_mean",               #response
  df = vi
)

}
