% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapsibleTreeSummary.R
\name{collapsibleTreeSummary}
\alias{collapsibleTreeSummary}
\title{Create Summary Interactive Collapsible Tree Diagrams}
\source{
Christopher Gandrud: \url{http://christophergandrud.github.io/networkD3/}.

d3noob: \url{https://bl.ocks.org/d3noob/43a860bc0024792f8803bba8ca0d5ecd}.
}
\usage{
collapsibleTreeSummary(df, hierarchy, root = deparse(substitute(df)),
  inputId = NULL, width = NULL, height = NULL, attribute = "leafCount",
  fillFun = colorspace::heat_hcl, maxPercent = 25, linkLength = NULL,
  fontSize = 10, tooltip = TRUE, ...)
}
\arguments{
\item{df}{a data frame from which to construct a nested list}

\item{hierarchy}{a character vector of column names that define the order
and hierarchy of the tree network}

\item{root}{label for the root node}

\item{inputId}{the input slot that will be used to access the selected node (for Shiny).
Will return a named list of the most recently clicked node,
along with all of its parents.}

\item{width}{width in pixels (optional, defaults to automatic sizing)}

\item{height}{height in pixels (optional, defaults to automatic sizing)}

\item{attribute}{numeric column not listed in hierarchy that will be used
as weighting to define the color gradient across nodes. Defaults to 'leafCount',
which colors nodes by the cumulative count of its children}

\item{fillFun}{function that takes its first argument and returns a vector
of colors of that length. \link[colorspace]{rainbow_hcl} is a good example.}

\item{maxPercent}{highest weighting percent to use in color scale mapping.
All numbers above this value will be treated as the same maximum value for the
sake of coloring in the nodes (but not the ordering of nodes). Setting this value
too high will make it difficult to tell the difference between nodes with many
children.}

\item{linkLength}{length of the horizontal links that connect nodes in pixels.
(optional, defaults to automatic sizing)}

\item{fontSize}{font size of the label text in pixels}

\item{tooltip}{tooltip shows the node's label and attribute value.}

\item{...}{other arguments passed on to \code{fillFun}, such declaring a
palette for \link[RColorBrewer]{brewer.pal}}
}
\description{
Interactive Reingold–Tilford tree diagram created using D3.js,
where every node can be expanded and collapsed by clicking on it.
This function serves as a convenience wrapper to add color gradients to nodes
either by counting that node's children (default) or specifying another numeric
column in the input data frame.
}
\examples{
# Color in by number of children
collapsibleTreeSummary(warpbreaks, c("wool", "tension", "breaks"), maxPercent = 50)

# Color in by the value of breaks and use the terrain_hcl gradient
collapsibleTreeSummary(
  warpbreaks,
  c("wool", "tension", "breaks"),
  attribute = "breaks",
  fillFun = colorspace::terrain_hcl,
  maxPercent = 50
)
}
